/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.item;

import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.collect.Ordering;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Item;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedItem;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.log.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public class ItemSet<T extends Item>
implements Cloneable,
Iterable<Class<? extends T>> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final AbstractItemManager manager;
    @Nonnull
    private long[] bitmap;
    @Nonnull
    public static final BooleanPropertyId COMPACT_TOSTRING = BooleanPropertyId.create("sched.itemset.compact", "Define if item sets are displayed compacted").addDefaultValue("false");

    public ItemSet(@Nonnull AbstractItemManager manager) {
        this.manager = manager;
        this.bitmap = new long[manager.getIntegersCount()];
    }

    public ItemSet(@Nonnull ItemSet<T> initial) {
        this(initial.manager);
        this.addAll(initial);
    }

    public boolean contains(@Nonnull Class<? extends T> item) {
        return this.contains(this.manager.getManagedItem(item));
    }

    public boolean contains(@Nonnull ManagedItem item) {
        return this.containsAll(item.getBitmap());
    }

    public boolean containsAll(@Nonnull ItemSet<T> set) {
        return this.containsAll(set.bitmap);
    }

    private boolean containsAll(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            if ((this.bitmap[i] & bitmap[i]) == bitmap[i]) continue;
            return false;
        }
        return true;
    }

    public boolean containsOne(@Nonnull ItemSet<T> set) {
        return this.containsOne(set.bitmap);
    }

    private boolean containsOne(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            if ((this.bitmap[i] & bitmap[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean containsNone(@Nonnull ItemSet<T> set) {
        return this.containsNone(set.bitmap);
    }

    private boolean containsNone(long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            if ((this.bitmap[i] & bitmap[i]) == 0L) continue;
            return false;
        }
        return true;
    }

    public void intersectWith(@Nonnull ItemSet<T> set) {
        this.computeIntersection(this, set);
    }

    protected void computeIntersection(@Nonnull ItemSet<T> inter, @Nonnull ItemSet<T> set) {
        inter.bitmap = this.intersection(set.bitmap);
    }

    @Nonnull
    private long[] intersection(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        long[] res = new long[this.manager.getIntegersCount()];
        for (int i = 0; i < this.bitmap.length; ++i) {
            res[i] = this.bitmap[i] & bitmap[i];
        }
        return res;
    }

    public final boolean equals(@CheckForNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemSet) {
            ItemSet set = (ItemSet)obj;
            return this.bitmapEquals(set.bitmap);
        }
        return false;
    }

    private boolean bitmapEquals(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            if (this.bitmap[i] == bitmap[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hashCode = 0;
        for (long element : this.bitmap) {
            hashCode = hashCode ^ (int)(element & 0xFFFFFFFFFFFFFFFFL) ^ (int)(element >> 32);
        }
        return hashCode;
    }

    @Nonnull
    public ItemSet<T> add(@Nonnull Class<? extends T> item) {
        return this.add(this.manager.getManagedItem(item));
    }

    @Nonnull
    public ItemSet<T> add(@Nonnull ManagedItem item) {
        this.add(item.getBitmap());
        return this;
    }

    private void add(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            int n = i;
            this.bitmap[n] = this.bitmap[n] | bitmap[i];
        }
    }

    @Nonnull
    public ItemSet<T> addAll(@Nonnull ItemSet<T> set) {
        this.add(set.bitmap);
        return this;
    }

    @Nonnull
    public ItemSet<T> remove(@Nonnull Class<? extends T> item) {
        return this.remove(this.manager.getManagedItem(item));
    }

    @Nonnull
    public ItemSet<T> remove(@Nonnull ManagedItem item) {
        this.remove(item.getBitmap());
        return this;
    }

    @Nonnull
    private ItemSet<T> remove(@Nonnull long[] bitmap) {
        assert (this.bitmap.length == bitmap.length);
        for (int i = 0; i < this.bitmap.length; ++i) {
            int n = i;
            this.bitmap[n] = this.bitmap[n] & (bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    @Nonnull
    public ItemSet<T> removeAll(@Nonnull ItemSet<T> set) {
        this.remove(set.bitmap);
        return this;
    }

    @Nonnull
    public ItemSet<T> clear() {
        for (int i = 0; i < this.bitmap.length; ++i) {
            this.bitmap[i] = 0L;
        }
        return this;
    }

    @Nonnegative
    public int getSize() {
        return this.getSize(this.bitmap);
    }

    @Nonnegative
    private int getSize(@Nonnull long[] bitmap) {
        int size = 0;
        long[] lArray = bitmap;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long mask = lArray[i]; mask != 0L; mask >>>= 1) {
                if ((mask & 1L) != 1L) continue;
                ++size;
            }
        }
        return size;
    }

    public boolean isEmpty() {
        for (long element : this.bitmap) {
            if (element == 0L) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String toString() {
        if (ThreadConfig.get(COMPACT_TOSTRING).booleanValue()) {
            return this.toStringCompact();
        }
        return this.toStringRaw();
    }

    @Nonnull
    public String toStringRaw() {
        ArrayList<String> names = new ArrayList<String>();
        ItemIterator iter = new ItemIterator(this);
        while (iter.hasNext()) {
            names.add(Items.getName((Class<? extends Item>)iter.next()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Joiner.on(", ").appendTo(sb, (Iterable<?>)Ordering.from(String.CASE_INSENSITIVE_ORDER).immutableSortedCopy(names));
        sb.append(']');
        return sb.toString();
    }

    @Nonnull
    public String toStringCompact() {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<T> item : this.getCompactSet()) {
            names.add(Items.getName(item));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Joiner.on(", ").appendTo(sb, (Iterable<?>)Ordering.from(String.CASE_INSENSITIVE_ORDER).immutableSortedCopy(names));
        sb.append(']');
        return sb.toString();
    }

    @Nonnull
    public Set<Class<? extends T>> getCompactSet() {
        ItemSet<T> items = new ItemSet<T>(this);
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        ManagedItem bestItem = null;
        int best = 0;
        while (!items.isEmpty()) {
            for (ManagedItem item : this.manager.getManagedItems()) {
                int size;
                assert (item.bitmap != null);
                if (!super.containsAll(item.bitmap) || (size = this.getSize(item.bitmap)) <= best) continue;
                best = size;
                bestItem = item;
            }
            if (bestItem != null) {
                set.add(bestItem.getItem());
                assert (bestItem.bitmap != null);
                super.remove(bestItem.bitmap);
                best = 0;
                bestItem = null;
                continue;
            }
            throw new AssertionError();
        }
        return set;
    }

    @Nonnull
    public ItemSet<T> clone() {
        try {
            ItemSet cloned = (ItemSet)super.clone();
            cloned.bitmap = (long[])this.bitmap.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            logger.log(Level.SEVERE, "Programm can not be here", e);
            throw new AssertionError((Object)e);
        }
    }

    @Nonnull
    public Iterator<ManagedItem> managedIterator() {
        return new ManagedItemIterator(this);
    }

    @Override
    @Nonnull
    public Iterator<Class<? extends T>> iterator() {
        return new ItemIterator(this);
    }

    private class ManagedItemIterator<T extends Item>
    implements Iterator<ManagedItem> {
        private int ptrIntegers = 0;
        private int ptrBits = 0;
        private long mask;
        private final ItemSet<? extends T> set;

        ManagedItemIterator(ItemSet<? extends T> set) {
            this.set = set;
            this.mask = ((ItemSet)set).bitmap[0];
        }

        @Override
        public boolean hasNext() {
            while (this.mask == 0L) {
                ++this.ptrIntegers;
                if (this.ptrIntegers < ((ItemSet)this.set).bitmap.length) {
                    this.mask = ((ItemSet)this.set).bitmap[this.ptrIntegers];
                    this.ptrBits = 0;
                    continue;
                }
                return false;
            }
            while ((this.mask & 1L) == 0L) {
                ++this.ptrBits;
                this.mask >>>= 1;
            }
            return true;
        }

        @Override
        @Nonnull
        public ManagedItem next() {
            this.mask >>>= 1;
            return ((ItemSet)this.set).manager.getManagedItem(this.ptrIntegers, this.ptrBits++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ItemIterator<T extends Item>
    implements Iterator<Class<? extends T>> {
        @Nonnull
        private final ManagedItemIterator<T> iterator;

        ItemIterator(ItemSet<? extends T> set) {
            this.iterator = new ManagedItemIterator<T>(set);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Nonnull
        public Class<? extends T> next() {
            return this.iterator.next().getItem();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

