/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.build;

import com.android.sched.build.SchedDiscover;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class SchedAnnotationProcessor
extends AbstractProcessor {
    @CheckForNull
    private ProcessingEnvironment env;
    @CheckForNull
    private DataProcessor data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.env = env;
        this.data = new DataProcessor(env);
        try {
            FileObject fo = env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.data.getResourceName());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fo.openInputStream()));){
                this.data.readResource(reader);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Items.init(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            assert (this.data != null);
            assert (this.env != null);
            try {
                OutputStream os = this.env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.data.getResourceName(), new Element[0]).openOutputStream();
                try (OutputStreamWriter writer = new OutputStreamWriter(os);){
                    this.data.writeResource(writer);
                }
            }
            catch (IOException e) {
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot write resource file for '" + this.data.getResourceName() + "': " + e.getMessage());
            }
        } else {
            try {
                this.processAnnotations(annotations, roundEnv);
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }
        return false;
    }

    private void processAnnotations(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment roundEnv) throws AbortException {
        TypeMirror type;
        assert (this.env != null);
        Items.reset();
        for (Element element : this.getElementsAnnotatedWith(roundEnv, Items.DESCRIPTION)) {
            assert (this.data != null);
            type = element.asType();
            if (type.getKind() != TypeKind.DECLARED) continue;
            for (Items item : Items.values()) {
                assert (this.env != null);
                if (this.env.getTypeUtils().isAssignable(type, item.getTypeMirror())) {
                    item.check(this.env, element);
                    this.data.add(item.getFQName(), (TypeElement)element);
                    continue;
                }
                this.data.remove(item.getFQName(), (TypeElement)element);
            }
        }
        for (Element element : this.getElementsAnnotatedWith(roundEnv, Items.HASKEYID)) {
            assert (this.data != null);
            type = element.asType();
            if (type.getKind() != TypeKind.DECLARED) continue;
            Items.HASKEYID.check(this.env, element);
            this.data.add(Items.HASKEYID.getFQName(), (TypeElement)element);
        }
        for (Element element : this.getElementsAnnotatedWith(roundEnv, Items.IMPLEMENTATION_NAME)) {
            assert (this.env != null);
            assert (this.data != null);
            TypeMirror elementType = element.asType();
            if (elementType.getKind() != TypeKind.DECLARED) continue;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!this.env.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), Items.IMPLEMENTATION_NAME.getTypeMirror())) continue;
                AnnotationValue name = null;
                TypeMirror iface = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    String attributeName = entry.getKey().getSimpleName().toString();
                    if (attributeName.equals("name")) {
                        name = entry.getValue();
                    }
                    if (!attributeName.equals("iface")) continue;
                    iface = (TypeMirror)entry.getValue().getValue();
                }
                if (iface != null && name != null) {
                    String ifaceName = iface.toString();
                    this.data.remove(ifaceName, (TypeElement)element);
                    for (SchedDiscover.SchedData elt : this.data.get(ifaceName)) {
                        if (!name.getValue().equals(elt.getExtra())) continue;
                        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Same name '" + name.getValue().toString() + "' on '" + elt.getName() + "'", element, annotationMirror, name);
                    }
                    if (!this.env.getTypeUtils().isAssignable(element.asType(), iface)) {
                        this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Must extends or implements '" + ifaceName + "'", element);
                    }
                    this.data.add(ifaceName, (TypeElement)element, name.getValue().toString());
                    continue;
                }
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Wrong @" + Items.IMPLEMENTATION_NAME.getFQName() + " annotation, must have 'iface' and 'name' attributes");
            }
        }
    }

    @Nonnull
    private Set<? extends Element> getElementsAnnotatedWith(@Nonnull RoundEnvironment roundEnv, @Nonnull Items item) throws AbortException {
        assert (this.env != null);
        return roundEnv.getElementsAnnotatedWith(item.getTypeElement());
    }

    private static class DataProcessor
    extends SchedDiscover {
        @Nonnull
        private final ProcessingEnvironment env;

        private DataProcessor(@Nonnull ProcessingEnvironment env) {
            this.env = env;
        }

        private void add(@Nonnull String sup, @Nonnull TypeElement element) {
            this.add(sup, this.env.getElementUtils().getBinaryName(element).toString());
        }

        private void add(@Nonnull String sup, @Nonnull TypeElement element, @Nonnull String extra) {
            this.add(sup, this.env.getElementUtils().getBinaryName(element).toString(), extra);
        }

        private void remove(@Nonnull String sup, @Nonnull TypeElement element) {
            this.remove(sup, this.env.getElementUtils().getBinaryName(element).toString());
        }

        @Override
        public void readResource(@Nonnull BufferedReader reader) throws IOException {
            super.readResource(reader);
            for (Set set : this.map.values()) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    String name = ((SchedDiscover.SchedData)iter.next()).getName();
                    TypeElement te = this.env.getElementUtils().getTypeElement(name);
                    if (te != null) continue;
                    iter.remove();
                }
            }
        }

        @Override
        public void writeResource(@Nonnull Writer writer) throws IOException {
            this.writeResource(writer, SchedAnnotationProcessor.class.getCanonicalName());
        }
    }

    private static class Items
    extends Enum<Items> {
        public static final /* enum */ Items KEY_ID = new Items("com.android.sched.util.config.id.KeyId");
        public static final /* enum */ Items HASKEYID = new Items("com.android.sched.util.config.HasKeyId"){

            @Override
            public void check(@Nonnull ProcessingEnvironment env, @Nonnull Element element) throws AbortException {
                TypeMirror keyIdType = env.getTypeUtils().erasure(KEY_ID.getTypeMirror());
                boolean noKeyId = true;
                for (Element element2 : element.getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.FIELD || !env.getTypeUtils().isSubtype(env.getTypeUtils().erasure(element2.asType()), keyIdType)) continue;
                    noKeyId = false;
                    if (!element2.getModifiers().contains((Object)Modifier.STATIC)) {
                        env.getMessager().printMessage(Diagnostic.Kind.WARNING, "KeyId should be declared static", element2);
                    }
                    if (element2.getModifiers().contains((Object)Modifier.FINAL)) continue;
                    env.getMessager().printMessage(Diagnostic.Kind.ERROR, "KeyId must be declared final", element2);
                }
                if (noKeyId) {
                    env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type does not contains KeyId", element);
                }
            }
        };
        public static final /* enum */ Items DESCRIPTION = new Items("com.android.sched.item.Description");
        public static final /* enum */ Items MARKER = new Items("com.android.sched.marker.Marker");
        public static final /* enum */ Items FEATURE = new Items("com.android.sched.item.Feature");
        public static final /* enum */ Items FILTER = new Items("com.android.sched.schedulable.ComponentFilter"){

            @Override
            @Nonnull
            public TypeMirror getTypeMirror() throws AbortException {
                return env.getTypeUtils().getDeclaredType(this.getTypeElement(), env.getTypeUtils().getWildcardType(null, null));
            }
        };
        public static final /* enum */ Items PRODUCTION = new Items("com.android.sched.item.Production");
        public static final /* enum */ Items TOMOC = new Items("com.android.sched.item.TagOrMarkerOrComponent");
        public static final /* enum */ Items SCHEDULABLE = new Items("com.android.sched.schedulable.Schedulable");
        public static final /* enum */ Items VARIABLE_NAME = new Items("com.android.sched.util.codec.VariableName");
        public static final /* enum */ Items IMPLEMENTATION_NAME = new Items("com.android.sched.util.codec.ImplementationName");
        @Nonnull
        private final String fqName;
        @CheckForNull
        private TypeElement typeElement;
        @CheckForNull
        private static ProcessingEnvironment env;
        private static final /* synthetic */ Items[] $VALUES;

        public static Items[] values() {
            return (Items[])$VALUES.clone();
        }

        public static Items valueOf(String name) {
            return Enum.valueOf(Items.class, name);
        }

        static void init(@Nonnull ProcessingEnvironment env) {
            Items.env = env;
            Items.reset();
        }

        static void reset() {
            for (Items item : Items.values()) {
                item.typeElement = null;
            }
        }

        private Items(String fqName) {
            this.fqName = fqName;
        }

        @Nonnull
        public String getFQName() {
            return this.fqName;
        }

        @Nonnull
        public TypeElement getTypeElement() throws AbortException {
            assert (env != null);
            if (this.typeElement == null) {
                this.typeElement = env.getElementUtils().getTypeElement(this.fqName);
                if (this.typeElement == null) {
                    env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can not get element type '" + this.fqName + "'");
                    throw new AbortException();
                }
            }
            return this.typeElement;
        }

        @Nonnull
        public TypeMirror getTypeMirror() throws AbortException {
            return this.getTypeElement().asType();
        }

        public void check(@Nonnull ProcessingEnvironment env, @Nonnull Element element) throws AbortException {
        }

        static {
            $VALUES = new Items[]{KEY_ID, HASKEYID, DESCRIPTION, MARKER, FEATURE, FILTER, PRODUCTION, TOMOC, SCHEDULABLE, VARIABLE_NAME, IMPLEMENTATION_NAME};
        }
    }

    private static class AbortException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AbortException() {
        }
    }
}

