/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SignatureParser {
    private SignatureParser() {
    }

    public static boolean isTypeSignature(@Nonnull String signature) {
        int length = signature.length();
        if (length == 0) {
            return false;
        }
        char[] buffer = signature.toCharArray();
        if (buffer[0] == 'V') {
            return length == 1;
        }
        return SignatureParser.isTypeSignatureWithoutVoid(buffer, 0, length);
    }

    private static boolean isTypeSignatureWithoutVoid(@Nonnull char[] buffer, @Nonnegative int pos, @Nonnegative int length) {
        if (pos >= length) {
            return false;
        }
        switch (buffer[pos++]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos == length;
            }
            case 'L': {
                return SignatureParser.isClassSignature(buffer, pos, length);
            }
            case '[': {
                return SignatureParser.isTypeSignatureWithoutVoid(buffer, pos, length);
            }
        }
        return false;
    }

    public static boolean isClassSignature(@Nonnull String signature) {
        char[] buffer = signature.toCharArray();
        int length = buffer.length;
        if (length < 3 || buffer[0] != 'L') {
            return false;
        }
        return SignatureParser.isClassSignature(buffer, 1, length);
    }

    private static boolean isClassSignature(@Nonnull char[] buffer, @Nonnegative int pos, @Nonnegative int length) {
        char ch;
        do {
            if (pos >= length) {
                return false;
            }
            if (SignatureParser.isInvalidChar(ch = buffer[pos++]) || ch == '/' || ch == ';') {
                return false;
            }
            do {
                if (pos >= length) {
                    return false;
                }
                if (!SignatureParser.isInvalidChar(ch = buffer[pos++])) continue;
                return false;
            } while (ch != '/' && ch != ';');
        } while (ch != ';');
        return pos == length;
    }

    private static boolean isInvalidChar(char ch) {
        switch (ch) {
            case '.': 
            case '[': {
                return true;
            }
        }
        return false;
    }
}

