/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.util.SignatureParser;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NamingTools {
    private static final char NON_SOURCE_CONFLICTING_CHAR = '-';
    private static final char GENERATED_FILE_SUPPORTED_CHAR = '_';
    public static final char PACKAGE_SOURCE_SEPARATOR = '.';
    public static final String STATIC_INIT_NAME = "<clinit>";
    public static final String INIT_NAME = "<init>";

    @Nonnull
    public static String getNonSourceConflictingName(@Nonnull String name) {
        return '-' + NamingTools.getValidName(name);
    }

    @Nonnull
    public static String getStrictNonSourceConflictingName(@Nonnull String name) {
        return '-' + name.replace('/', '-');
    }

    public static boolean isNameSynthetic(@Nonnull String name) {
        return name.indexOf(45) != -1;
    }

    @Nonnull
    public static String getValidName(@Nonnull String name) {
        return name.replace('/', '_');
    }

    @Nonnull
    public static String getTypeSignatureName(@Nonnull String typeName) {
        return 'L' + NamingTools.getBinaryName(typeName) + ';';
    }

    @Nonnull
    public static String getBinaryName(@Nonnull String srcSymbolName) {
        return srcSymbolName.replace('.', '/');
    }

    @Nonnull
    public static String getClassBinaryNameFromDescriptor(@Nonnull String classDescriptor) {
        assert (NamingTools.isClassDescriptor(classDescriptor)) : "Invalid class descriptor " + classDescriptor;
        return classDescriptor.substring(1, classDescriptor.length() - 1);
    }

    @Nonnull
    public static String getSimpleClassNameFromBinaryName(@Nonnull String classBinaryName) {
        int simpleNameIndex = classBinaryName.lastIndexOf(47);
        return simpleNameIndex < 0 ? classBinaryName : classBinaryName.substring(simpleNameIndex + 1);
    }

    @Nonnull
    public static String getSimpleClassNameFromDescriptor(@Nonnull String classDescriptor) {
        return NamingTools.getSimpleClassNameFromBinaryName(NamingTools.getClassBinaryNameFromDescriptor(classDescriptor));
    }

    @Nonnull
    public static String getPackageNameFromBinaryName(@Nonnull String binaryName) {
        int nameIndex = binaryName.lastIndexOf(47);
        return nameIndex < 0 ? "" : binaryName.substring(0, nameIndex);
    }

    public static boolean isTypeIdentifier(@Nonnull String name) {
        int nameLength = name.length();
        if (nameLength == 0) {
            return false;
        }
        for (int i = 1; i < nameLength; ++i) {
            char curChar = name.charAt(i);
            if (curChar != '.' && curChar != ';' && curChar != '[' && curChar != '/') continue;
            return false;
        }
        return true;
    }

    public static boolean isClassDescriptor(@Nonnull String descriptor) {
        return SignatureParser.isClassSignature(descriptor);
    }

    public static boolean isTypeDescriptor(@Nonnull String descriptor) {
        return SignatureParser.isTypeSignature(descriptor);
    }

    public static boolean isPackageBinaryName(@Nonnull String name) {
        return NamingTools.isClassOrPackageName(name.toCharArray(), 0, name.length(), '/', '.');
    }

    public static boolean isPackageSourceName(@Nonnull String name) {
        return NamingTools.isClassOrPackageName(name.toCharArray(), 0, name.length(), '.', '/');
    }

    public static boolean isClassSourceName(@Nonnull String name) {
        return NamingTools.isClassOrPackageName(name.toCharArray(), 0, name.length(), '.', '/');
    }

    private static boolean isClassOrPackageName(@Nonnull char[] buffer, @Nonnegative int pos, @Nonnegative int length, char usedSeparator, char forbiddenSeparator) {
        while (pos < length) {
            char ch;
            if ((ch = buffer[pos++]) == '[' || ch == forbiddenSeparator || ch == usedSeparator || ch == ';') {
                return false;
            }
            while (ch != usedSeparator && pos < length) {
                if ((ch = buffer[pos++]) != '[' && ch != forbiddenSeparator) continue;
                return false;
            }
            if (ch != usedSeparator || pos < length) continue;
            return false;
        }
        return true;
    }
}

