/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConcatOperation;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPostfixOperation;
import com.android.jack.ir.ast.JPrefixOperation;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.sched.marker.Marker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CloneExpressionVisitor
extends JVisitor {
    @CheckForNull
    protected JExpression expression;

    @Nonnull
    public <T extends JExpression> T cloneExpression(@Nonnull T expr) {
        this.expression = null;
        this.accept(expr);
        if (this.expression == null) {
            throw new AssertionError((Object)("Unable to clone expression " + expr.toString()));
        }
        for (Marker m : expr.getAllMarkers()) {
            this.expression.addMarker(m.cloneIfNeeded());
        }
        assert (this.expression != null);
        return (T)this.expression;
    }

    @Nonnull
    public List<JExpression> cloneExpressions(@Nonnull List<? extends JExpression> exprs) {
        ArrayList<JExpression> result = new ArrayList<JExpression>();
        for (JExpression jExpression : exprs) {
            result.add(this.cloneExpression(jExpression));
        }
        return result;
    }

    @Override
    public boolean visit(@Nonnull JAbsentArrayDimension x) {
        this.expression = new JAbsentArrayDimension(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAbstractStringLiteral x) {
        this.expression = (JAbstractStringLiteral)x.clone();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAlloc x) {
        this.expression = new JAlloc(x.getSourceInfo(), x.getInstanceType());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAnnotation annotation) {
        JAnnotation clonedAnnotationliteral = new JAnnotation(annotation.getSourceInfo(), annotation.getRetentionPolicy(), annotation.getType());
        for (JNameValuePair nvp : annotation.getNameValuePairs()) {
            clonedAnnotationliteral.add(new JNameValuePair(nvp.getSourceInfo(), nvp.getMethodId(), this.cloneExpression(nvp.getValue())));
        }
        this.expression = clonedAnnotationliteral;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayLength x) {
        this.expression = new JArrayLength(x.getSourceInfo(), this.cloneExpression(x.getInstance()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayLiteral arrayLiteral) {
        this.expression = new JArrayLiteral(arrayLiteral.getSourceInfo(), (ArrayList)this.cloneExpressions(arrayLiteral.getValues()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayRef x) {
        this.expression = new JArrayRef(x.getSourceInfo(), this.cloneExpression(x.getInstance()), this.cloneExpression(x.getIndexExpr()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBinaryOperation x) {
        this.expression = x instanceof JConcatOperation ? new JConcatOperation(x.getSourceInfo(), (JClass)x.getType(), this.cloneExpression(x.getLhs()), this.cloneExpression(x.getRhs())) : JBinaryOperation.create(x.getSourceInfo(), x.getOp(), this.cloneExpression(x.getLhs()), this.cloneExpression(x.getRhs()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBooleanLiteral x) {
        this.expression = new JBooleanLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JByteLiteral x) {
        this.expression = new JByteLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JCharLiteral x) {
        this.expression = new JCharLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JClassLiteral x) {
        JClassLiteral classLiteral = new JClassLiteral(x.getSourceInfo(), x.getRefType(), (JClass)x.getType());
        this.expression = classLiteral;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JConditionalExpression x) {
        this.expression = new JConditionalExpression(x.getSourceInfo(), this.cloneExpression(x.getIfTest()), this.cloneExpression(x.getThenExpr()), this.cloneExpression(x.getElseExpr()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDoubleLiteral x) {
        this.expression = new JDoubleLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDynamicCastOperation x) {
        this.expression = new JDynamicCastOperation(x.getSourceInfo(), this.cloneExpression(x.getExpr()), x.getTypes());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JExceptionRuntimeValue x) {
        this.expression = new JExceptionRuntimeValue(x.getSourceInfo(), (JClassOrInterface)x.getType());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFieldRef x) {
        JExpression instanceRef = x.getInstance();
        this.expression = new JFieldRef(x.getSourceInfo(), instanceRef != null ? this.cloneExpression(instanceRef) : null, x.getFieldId(), x.getReceiverType());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFloatLiteral x) {
        this.expression = new JFloatLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JInstanceOf x) {
        this.expression = new JInstanceOf(x.getSourceInfo(), x.getTestType(), this.cloneExpression(x.getExpr()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JIntLiteral x) {
        this.expression = new JIntLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLocalRef x) {
        this.expression = x.getLocal().makeRef(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLongLiteral x) {
        this.expression = new JLongLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethodCall x) {
        JExpression instance = x.getInstance();
        JExpression clonedInstance = null;
        if (instance != null) {
            clonedInstance = this.cloneExpression(instance);
        }
        JMethodCall newMethodCall = new JMethodCall(x, clonedInstance);
        newMethodCall.addArgs(this.cloneExpressions(x.getArgs()));
        this.expression = newMethodCall;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethodLiteral methodLiteral) {
        this.expression = new JMethodLiteral(methodLiteral.getMethod(), methodLiteral.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMultiExpression x) {
        JMultiExpression multi = new JMultiExpression(x.getSourceInfo(), this.cloneExpressions(x.exprs));
        this.expression = multi;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNewArray x) {
        this.expression = x.getInitializers().isEmpty() ? JNewArray.createWithDims(x.getSourceInfo(), x.getArrayType(), this.cloneExpressions(x.getDims())) : JNewArray.createWithInits(x.getSourceInfo(), x.getArrayType(), this.cloneExpressions(x.getInitializers()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNewInstance x) {
        JNewInstance newInstance = new JNewInstance(x);
        newInstance.addArgs(this.cloneExpressions(x.getArgs()));
        this.expression = newInstance;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNullLiteral x) {
        this.expression = new JNullLiteral(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JParameterRef x) {
        this.expression = x.getParameter().makeRef(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPostfixOperation x) {
        this.expression = JPostfixOperation.create(x.getSourceInfo(), x.getOp(), this.cloneExpression(x.getArg()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPrefixOperation x) {
        this.expression = JPrefixOperation.create(x.getSourceInfo(), x.getOp(), this.cloneExpression(x.getArg()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JShortLiteral x) {
        this.expression = new JShortLiteral(x.getSourceInfo(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThisRef x) {
        this.expression = x.getTarget().makeRef(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLambda lambda) {
        JLambda clonedLambda = new JLambda(lambda.getSourceInfo(), lambda.getMethodIdWithErasure(), lambda.getMethodIdRef(), lambda.getType(), lambda.getInterfaceBounds(), lambda.getMethodIdWithoutErasure());
        for (JExpression capturedVar : lambda.getCapturedVariables()) {
            clonedLambda.addCapturedVariable(this.cloneExpression(capturedVar));
        }
        this.expression = clonedLambda;
        return false;
    }
}

