/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.CandidateFactory;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Replacement<T>
implements EvolutionaryOperator<T> {
    private final CandidateFactory<T> factory;
    private final NumberGenerator<Probability> replacementProbability;

    public Replacement(CandidateFactory<T> factory, Probability replacementProbability) {
        this(factory, new ConstantGenerator<Probability>(replacementProbability));
    }

    public Replacement(CandidateFactory<T> factory, NumberGenerator<Probability> replacementProbability) {
        this.factory = factory;
        this.replacementProbability = replacementProbability;
    }

    @Override
    public List<T> apply(List<T> selectedCandidates, Random rng) {
        ArrayList<T> output = new ArrayList<T>(selectedCandidates.size());
        for (T candidate : selectedCandidates) {
            output.add(this.replacementProbability.nextValue().nextEvent(rng) ? this.factory.generateRandomCandidate(rng) : candidate);
        }
        return output;
    }
}

