/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public abstract class AbstractCrossover<T>
implements EvolutionaryOperator<T> {
    private final NumberGenerator<Integer> crossoverPointsVariable;
    private final NumberGenerator<Probability> crossoverProbabilityVariable;

    protected AbstractCrossover(int crossoverPoints) {
        this(crossoverPoints, Probability.ONE);
    }

    protected AbstractCrossover(int crossoverPoints, Probability crossoverProbability) {
        this(new ConstantGenerator<Integer>(crossoverPoints), new ConstantGenerator<Probability>(crossoverProbability));
        if (crossoverPoints <= 0) {
            throw new IllegalArgumentException("Number of cross-over points must be positive.");
        }
    }

    protected AbstractCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        this(crossoverPointsVariable, new ConstantGenerator<Probability>(Probability.ONE));
    }

    protected AbstractCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        this.crossoverPointsVariable = crossoverPointsVariable;
        this.crossoverProbabilityVariable = crossoverProbabilityVariable;
    }

    @Override
    public List<T> apply(List<T> selectedCandidates, Random rng) {
        ArrayList<T> selectionClone = new ArrayList<T>(selectedCandidates);
        Collections.shuffle(selectionClone, rng);
        ArrayList result = new ArrayList(selectedCandidates.size());
        Iterator iterator = selectionClone.iterator();
        while (iterator.hasNext()) {
            Object parent1 = iterator.next();
            if (iterator.hasNext()) {
                int crossoverPoints;
                Object parent2 = iterator.next();
                int n = crossoverPoints = this.crossoverProbabilityVariable.nextValue().nextEvent(rng) ? this.crossoverPointsVariable.nextValue() : 0;
                if (crossoverPoints > 0) {
                    result.addAll(this.mate(parent1, parent2, crossoverPoints, rng));
                    continue;
                }
                result.add(parent1);
                result.add(parent2);
                continue;
            }
            result.add(parent1);
        }
        return result;
    }

    protected abstract List<T> mate(T var1, T var2, int var3, Random var4);
}

