/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

public final class EvaluatedCandidate<T>
implements Comparable<EvaluatedCandidate<T>> {
    private final T candidate;
    private final double fitness;

    public EvaluatedCandidate(T candidate, double fitness) {
        if (fitness < 0.0) {
            throw new IllegalArgumentException("Fitness score must be greater than or equal to zero.");
        }
        this.candidate = candidate;
        this.fitness = fitness;
    }

    public T getCandidate() {
        return this.candidate;
    }

    public double getFitness() {
        return this.fitness;
    }

    @Override
    public int compareTo(EvaluatedCandidate<T> evaluatedCandidate) {
        return Double.compare(this.fitness, evaluatedCandidate.getFitness());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedCandidate that = (EvaluatedCandidate)o;
        return Double.compare(that.getFitness(), this.fitness) == 0;
    }

    public int hashCode() {
        long temp = this.fitness == 0.0 ? 0L : Double.doubleToLongBits(this.fitness);
        return (int)(temp ^ temp >>> 32);
    }
}

