/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

import com.android.jack.google.common.collect.MapMaker;
import com.android.jack.uncommons.watchmaker.framework.FitnessEvaluator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public class CachingFitnessEvaluator<T>
implements FitnessEvaluator<T> {
    private final FitnessEvaluator<T> delegate;
    private final transient ConcurrentMap<T, Double> cache = new MapMaker().weakKeys().makeMap();

    public CachingFitnessEvaluator(FitnessEvaluator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public double getFitness(T candidate, List<? extends T> population) {
        Double fitness = (Double)this.cache.get(candidate);
        if (fitness == null) {
            fitness = this.delegate.getFitness((T)candidate, population);
            this.cache.put(candidate, fitness);
        }
        return fitness;
    }

    @Override
    public boolean isNatural() {
        return this.delegate.isNatural();
    }
}

