/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T invokeUnchecked(Method method, Object target, Object ... arguments) {
        try {
            Object result = method.invoke(target, arguments);
            return (T)result;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Method " + method.getName() + " is not publicly accessible.", ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            throw (RuntimeException)ex.getCause();
        }
    }

    public static <T> T invokeUnchecked(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Constructor is not publicly accessible.", ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Constructor is part of an abstract class.", ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            throw (RuntimeException)ex.getCause();
        }
    }

    public static Method findKnownMethod(Class<?> aClass, String name, Class<?> ... paramTypes) {
        try {
            return aClass.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Method " + name + " does not exist in class " + aClass.getName(), ex);
        }
    }

    public static <T> Constructor<T> findKnownConstructor(Class<T> aClass, Class<?> ... paramTypes) {
        try {
            return aClass.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Specified constructor does not exist in class " + aClass.getName(), ex);
        }
    }
}

