/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.binary.BinaryUtils;
import com.android.jack.uncommons.maths.random.DefaultSeedGenerator;
import com.android.jack.uncommons.maths.random.RepeatableRNG;
import com.android.jack.uncommons.maths.random.SeedException;
import com.android.jack.uncommons.maths.random.SeedGenerator;
import java.util.Random;

public class JavaRNG
extends Random
implements RepeatableRNG {
    private static final int SEED_SIZE_BYTES = 8;
    private final byte[] seed;

    public JavaRNG() {
        this(DefaultSeedGenerator.getInstance().generateSeed(8));
    }

    public JavaRNG(SeedGenerator seedGenerator) throws SeedException {
        this(seedGenerator.generateSeed(8));
    }

    public JavaRNG(byte[] seed) {
        super(JavaRNG.createLongSeed(seed));
        this.seed = (byte[])seed.clone();
    }

    private static long createLongSeed(byte[] seed) {
        if (seed == null || seed.length != 8) {
            throw new IllegalArgumentException("Java RNG requires a 64-bit (8-byte) seed.");
        }
        return BinaryUtils.convertBytesToLong(seed, 0);
    }

    @Override
    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }
}

