/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import java.util.Random;

public class GaussianGenerator
implements NumberGenerator<Double> {
    private final Random rng;
    private final NumberGenerator<Double> mean;
    private final NumberGenerator<Double> standardDeviation;

    public GaussianGenerator(NumberGenerator<Double> mean, NumberGenerator<Double> standardDeviation, Random rng) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
        this.rng = rng;
    }

    public GaussianGenerator(double mean, double standardDeviation, Random rng) {
        this(new ConstantGenerator<Double>(mean), new ConstantGenerator<Double>(standardDeviation), rng);
    }

    @Override
    public Double nextValue() {
        return this.rng.nextGaussian() * this.standardDeviation.nextValue() + this.mean.nextValue();
    }
}

