/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.maths.random;

import com.android.jack.uncommons.maths.binary.BinaryUtils;
import com.android.jack.uncommons.maths.binary.BitString;
import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import java.util.Random;

public class BinomialGenerator
implements NumberGenerator<Integer> {
    private final Random rng;
    private final NumberGenerator<Integer> n;
    private final NumberGenerator<Double> p;
    private transient BitString pBits;
    private transient double lastP;

    public BinomialGenerator(NumberGenerator<Integer> n, NumberGenerator<Double> p, Random rng) {
        this.n = n;
        this.p = p;
        this.rng = rng;
    }

    public BinomialGenerator(int n, double p, Random rng) {
        this(new ConstantGenerator<Integer>(n), new ConstantGenerator<Double>(p), rng);
        if (n <= 0) {
            throw new IllegalArgumentException("n must be a positive integer.");
        }
        if (p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1.");
        }
    }

    @Override
    public Integer nextValue() {
        double newP = this.p.nextValue();
        if (this.pBits == null || newP != this.lastP) {
            this.lastP = newP;
            this.pBits = BinaryUtils.convertDoubleToFixedPointBits(newP);
        }
        int trials = this.n.nextValue();
        int totalSuccesses = 0;
        for (int pIndex = this.pBits.getLength() - 1; trials > 0 && pIndex >= 0; --pIndex) {
            int successes = this.binomialWithEvenProbability(trials);
            trials -= successes;
            if (!this.pBits.getBit(pIndex)) continue;
            totalSuccesses += successes;
        }
        return totalSuccesses;
    }

    private int binomialWithEvenProbability(int n) {
        BitString bits = new BitString(n, this.rng);
        return bits.countSetBits();
    }
}

