/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.threeaddresscode;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.SubTreeDefinitionMarkers;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JConditionalOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JUnaryOperator;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.collector.SubTreeMarkersCollector;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.BooleanTestOutsideIf;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.ast.RefAsStatement;
import com.android.jack.transformations.booleanoperators.FallThroughMarker;
import com.android.jack.transformations.cast.SourceCast;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.request.TransformationStep;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.AnnotationSkipperVisitor;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.transform.TransformStep;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Transform body of a JMethod to into a three address form.")
@Name(value="ThreeAddressCodeBuilder")
@Constraint(need={NoImplicitBlock.class, SourceCast.class}, no={BooleanTestOutsideIf.class, InitInNewArray.class, JAssertStatement.class, JAsgOperation.class, JFieldInitializer.class, JConditionalOperation.class, JLoop.class, JCastOperation.WithIntersectionType.class})
@Transform(add={ThreeAddressCodeForm.class, RefAsStatement.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class, JBlock.class, JIfStatement.class, JExpressionStatement.class}, remove={JConditionalExpression.class, JMultiExpression.class})
@Use(value={LocalVarCreator.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ThreeAddressCodeBuilder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ThreeAddressCode tcaBuilder = new ThreeAddressCode(method);
        tcaBuilder.accept(method);
        new SubTreeDefinitionMarkersRemover().accept(method);
    }

    private static class SubTreeDefinitionMarkersRemover
    extends JVisitor {
        private SubTreeDefinitionMarkersRemover() {
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            node.removeMarker(SubTreeDefinitionMarkers.class);
            return super.visit(node);
        }
    }

    private static class ThreeAddressCode
    extends AnnotationSkipperVisitor {
        @Nonnull
        private static final SubTreeMarkersCollector<DefinitionMarker> defMarkerCollector = new SubTreeMarkersCollector(SubTreeDefinitionMarkers.class);
        @CheckForNull
        private JStatement insertStatement;
        @Nonnull
        private final List<JStatement> newStmtToVisit = new LinkedList<JStatement>();
        @Nonnull
        private final JMethod method;
        @Nonnull
        private final LocalVarCreator localVarCreator;
        @Nonnull
        private List<JCatchBlock> currentCatchBlocks = new LinkedList<JCatchBlock>();

        public ThreeAddressCode(@Nonnull JMethod method) {
            this.method = method;
            this.localVarCreator = new LocalVarCreator(method, "tac");
        }

        @Override
        public boolean visit(@Nonnull JNewArray newArray) {
            this.accept(newArray.getDims());
            return false;
        }

        private boolean isRedefineVariable(@Nonnull List<DefinitionMarker> defs, @Nonnull JVariable var) {
            for (DefinitionMarker def : defs) {
                if (def.getDefinedVariable() != var) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endVisit(@Nonnull JExpression expr) {
            JBinaryOperation binaryOperation;
            JNode parent = expr.getParent();
            assert (this.insertStatement != null);
            if (expr instanceof JConditionalExpression || expr instanceof JValueLiteral && !expr.canThrow() || expr instanceof JVariableRef && !this.isRedefineVariable(expr.getMarkersOnNodesRightToPath(defMarkerCollector, this.insertStatement), ((JVariableRef)expr).getTarget()) || parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == expr) {
                return;
            }
            if ((expr instanceof JFieldRef || expr instanceof JArrayRef) && parent instanceof JBinaryOperation && (binaryOperation = (JBinaryOperation)parent).getLhs() == expr && binaryOperation.isAssignment()) {
                return;
            }
            if (parent instanceof JIfStatement) {
                if (expr instanceof JBinaryOperation && ((JBinaryOperation)expr).getOp().isComparison()) {
                    return;
                }
                if (expr instanceof JUnaryOperation && ((JUnaryOperation)expr).getOp() == JUnaryOperator.NOT) {
                    return;
                }
            }
            TransformationRequest transformationRequest = new TransformationRequest(this.method);
            if (expr instanceof JMultiExpression) {
                List<JExpression> exprs = ((JMultiExpression)expr).getExprs();
                if (exprs.size() > 0) {
                    if (parent instanceof JExpressionStatement) {
                        transformationRequest.append(new Remove(parent));
                    } else {
                        transformationRequest.append(new Replace(expr, exprs.get(exprs.size() - 1)));
                    }
                } else {
                    transformationRequest.append(new Remove(parent));
                }
            } else {
                if (expr.getType() == JPrimitiveType.JPrimitiveTypeEnum.VOID.getType() && !(parent instanceof JMultiExpression) || parent instanceof JExpressionStatement) {
                    return;
                }
                if (parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() instanceof JLocalRef) {
                    return;
                }
                if (expr instanceof JAsgOperation) {
                    if (expr.isResultUsed()) {
                        throw new AssertionError((Object)"Uses result of assign is not supported.");
                    }
                    JExpressionStatement stmt = expr.makeStatement();
                    stmt.setCatchBlocks(this.currentCatchBlocks);
                    transformationRequest.append(new Remove(expr));
                    assert (this.insertStatement != null);
                    transformationRequest.append(new AppendBefore(this.insertStatement, stmt));
                } else if (expr.getType() == JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) {
                    JExpressionStatement stmt = expr.makeStatement();
                    stmt.setCatchBlocks(this.currentCatchBlocks);
                    transformationRequest.append(new Remove(expr));
                    assert (this.insertStatement != null);
                    transformationRequest.append(new AppendBefore(this.insertStatement, stmt));
                } else {
                    SourceInfo sourceInfo = expr.getSourceInfo();
                    JType type = expr.getType();
                    JLocal tempLocal = this.localVarCreator.createTempLocal(type, sourceInfo, transformationRequest);
                    JLocalRef localRef = tempLocal.makeRef(sourceInfo);
                    transformationRequest.append(new Replace(expr, localRef));
                    assert (!(expr instanceof JAsgOperation));
                    JAsgOperation newBin = new JAsgOperation(sourceInfo, tempLocal.makeRef(sourceInfo), expr);
                    JExpressionStatement stmt = newBin.makeStatement();
                    stmt.setCatchBlocks(this.currentCatchBlocks);
                    assert (this.insertStatement != null);
                    transformationRequest.append(new AppendBefore(this.insertStatement, stmt));
                }
            }
            transformationRequest.commit();
        }

        @Override
        public boolean visit(@Nonnull JStatement stmt) {
            this.insertStatement = stmt;
            this.currentCatchBlocks = new ArrayList<JCatchBlock>(stmt.getJCatchBlocks());
            super.visit(stmt);
            return true;
        }

        @Override
        public void endVisit(@Nonnull JStatement stmt) {
            this.insertStatement = null;
            this.currentCatchBlocks.clear();
            LinkedList<JStatement> copyOfStmt = new LinkedList<JStatement>(this.newStmtToVisit);
            this.newStmtToVisit.clear();
            for (JStatement stmtToVisit : copyOfStmt) {
                this.accept(stmtToVisit);
            }
            super.endVisit(stmt);
        }

        @Override
        public boolean visit(@Nonnull JConditionalExpression conditional) {
            TransformStep endTransformation;
            JLocal local;
            TransformationRequest transformationRequest = new TransformationRequest(this.method);
            SourceInfo srcInfo = conditional.getSourceInfo();
            SourceInfo thenSrcInfo = conditional.getThenExpr().getSourceInfo();
            SourceInfo elseSourceInfo = conditional.getElseExpr().getSourceInfo();
            JType exprType = conditional.getType();
            JNode parentOfConditional = conditional.getParent();
            assert (parentOfConditional != null);
            if (parentOfConditional.getParent() == this.insertStatement && this.insertStatement instanceof JExpressionStatement && parentOfConditional instanceof JAsgOperation && ((JAsgOperation)parentOfConditional).getLhs() instanceof JLocalRef) {
                local = ((JLocalRef)((JAsgOperation)parentOfConditional).getLhs()).getLocal();
                endTransformation = new Remove(this.insertStatement);
            } else {
                local = this.localVarCreator.createTempLocal(exprType, srcInfo, transformationRequest);
                endTransformation = new Replace(conditional, local.makeRef(srcInfo));
            }
            JBlock thenBlock = new JBlock(thenSrcInfo);
            JBlock elseBlock = new JBlock(elseSourceInfo);
            JIfStatement ifStmt = new JIfStatement(conditional.getIfTest().getSourceInfo(), conditional.getIfTest(), thenBlock, elseBlock);
            this.newStmtToVisit.add(ifStmt);
            FallThroughMarker ftm = conditional.getMarker(FallThroughMarker.class);
            if (ftm != null) {
                ifStmt.addMarker(ftm);
            }
            JAsgOperation assign = new JAsgOperation(thenSrcInfo, local.makeRef(thenSrcInfo), conditional.getThenExpr());
            JExpressionStatement assignStmt = assign.makeStatement();
            thenBlock.addStmt(assignStmt);
            assign = new JAsgOperation(elseSourceInfo, local.makeRef(elseSourceInfo), conditional.getElseExpr());
            assignStmt = assign.makeStatement();
            elseBlock.addStmt(assignStmt);
            assert (this.insertStatement != null);
            transformationRequest.append(new AppendBefore(this.insertStatement, ifStmt));
            transformationRequest.append((TransformationStep)((Object)endTransformation));
            transformationRequest.commit();
            return false;
        }

        @Override
        public boolean visit(@Nonnull JTryStatement tryStmt) {
            this.accept(tryStmt.getTryBlock());
            this.accept(tryStmt.getCatchBlocks());
            JBlock finallyBlock = tryStmt.getFinallyBlock();
            if (finallyBlock != null) {
                this.accept(finallyBlock);
            }
            return false;
        }
    }
}

