/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.request;

import com.android.jack.ir.ast.JNode;
import com.android.jack.transformations.request.TransformationStep;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class TransformationRequest {
    @CheckForNull
    private List<TransformationStep> requests = new LinkedList<TransformationStep>();

    public TransformationRequest(@Nonnull JNode root) {
        assert (root != null);
    }

    public void append(@Nonnull TransformationStep step) {
        if (this.requests == null) {
            throw new IllegalStateException("The request has already been applied");
        }
        assert (this.requests != null);
        this.requests.add(step);
    }

    public void appendAll(Collection<TransformationStep> steps) {
        if (this.requests == null) {
            throw new IllegalStateException("The request has already been applied");
        }
        assert (this.requests != null);
        this.requests.addAll(steps);
    }

    public void commit() throws UnsupportedOperationException {
        if (this.requests == null) {
            throw new IllegalStateException("The same request cannot be applied twice");
        }
        assert (this.requests != null);
        for (TransformationStep step : this.requests) {
            step.apply();
        }
        this.requests = null;
    }
}

