/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.lambda;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.lambda.LambdaCollection;
import com.android.jack.transformations.lambda.LambdaCollectionMarker;
import com.android.jack.transformations.lambda.LambdaToAnonymousConverter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Collects information regarding the lambdas used in the code.")
@Constraint(need={JLambda.class, JLambda.DefaultBridgeAddedInLambda.class})
@Transform(add={LambdaCollectionMarker.class})
@Support(value={LambdaToAnonymousConverter.class})
@Access(value=JSession.class)
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class LambdaCollector
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private static final TypePackageAndMethodFormatter FORMATTER = Jack.getLookupFormatter();
    @Nonnull
    private final LambdaCollection collection;

    public LambdaCollector() {
        LambdaCollectionMarker existing;
        JSession session = Jack.getSession();
        LambdaCollectionMarker marker = session.getMarker(LambdaCollectionMarker.class);
        if (marker == null && (existing = session.addMarkerIfAbsent(marker = new LambdaCollectionMarker(new LambdaCollection()))) != null) {
            marker = existing;
        }
        this.collection = marker.getCollection();
    }

    @Override
    public void run(final @Nonnull JMethod method) {
        JVisitor processor = new JVisitor(){
            private int nextId = 0;

            @Override
            public boolean visit(@Nonnull JLambda lambda) {
                String lambdaId = FORMATTER.getName(method.getEnclosingType()) + ";;" + FORMATTER.getName(method) + ";;" + this.nextId++;
                LambdaCollector.this.collection.addLambda(method.getEnclosingType(), lambdaId, lambda);
                return true;
            }
        };
        processor.accept(method);
    }
}

