/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.finallyblock;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.finallyblock.InlinedFinallyMarker;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.CloneStatementVisitor;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.marker.Marker;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Removes finally blocks. Their contents are copied where they should.")
@Name(value="FinallyRemover")
@Constraint(need={NoImplicitBlock.class, JTryStatement.class}, no={JFieldInitializer.class})
@Transform(add={JTryStatement.class, JLocalRef.class, JThrowStatement.class, JBlock.class, InlinedFinallyMarker.class, JExpressionStatement.class}, remove={JTryStatement.FinallyBlock.class})
@Use(value={LocalVarCreator.class, CloneStatementVisitor.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class FinallyRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JClass throwableType = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest trRequest = new TransformationRequest(method);
        JTryStatementVisitor visitor = new JTryStatementVisitor(trRequest, method);
        visitor.accept(method);
        trRequest.commit();
    }

    private static class FinallyInliner
    extends JVisitor {
        @Nonnull
        private final JBlock finallyBlockToInsert;
        @Nonnull
        private final CloneStatementVisitor cloner;
        @Nonnull
        private final TransformationRequest currentRequest;
        @Nonnull
        private final JType throwableType;
        @Nonnull
        private final JMethod currentMethod;
        @Nonnull
        private final LocalVarCreator localForReturnCreator;
        @Nonnegative
        private int nameIndex = 0;
        @Nonnull
        private final List<InlinedFinallyMarker> inlinedFinallyMarkers;
        @Nonnull
        private final JTryStatement tryStmt;

        public FinallyInliner(@Nonnull JTryStatement tryStmt, @Nonnull JType throwableType, @Nonnull JMethod currentMethod, @Nonnull JBlock finallyBlockToInsert, @Nonnull TransformationRequest request, @Nonnull List<InlinedFinallyMarker> inlinedMarker) {
            this.tryStmt = tryStmt;
            this.throwableType = throwableType;
            this.currentMethod = currentMethod;
            this.finallyBlockToInsert = finallyBlockToInsert;
            this.currentRequest = request;
            this.cloner = new CloneStatementVisitor(request, currentMethod);
            this.localForReturnCreator = new LocalVarCreator(currentMethod, "ret");
            this.inlinedFinallyMarkers = inlinedMarker;
        }

        public void inlineFinally() {
            this.accept(this.tryStmt);
            JBlock tryBlock = this.tryStmt.getTryBlock();
            List<JCatchBlock> catchBlocks = this.tryStmt.getCatchBlocks();
            this.addFinallyAtEndOfBlock(tryBlock);
            for (JCatchBlock catchBlock : catchBlocks) {
                this.addFinallyAtEndOfBlock(catchBlock);
            }
            this.addCatchThrowableBlockWithFinallyStatements(this.tryStmt);
        }

        @Override
        public boolean visit(@Nonnull JReturnStatement returnStmt) {
            JExpression expr = returnStmt.getExpr();
            if (expr != null) {
                JLocal local = this.localForReturnCreator.createTempLocal(expr.getType(), expr.getSourceInfo(), this.currentRequest);
                JLocalRef returnedLocalRef = local.makeRef(expr.getSourceInfo());
                this.currentRequest.append(new Replace(expr, returnedLocalRef));
                JLocalRef assignedLocalRef = local.makeRef(expr.getSourceInfo());
                JAsgOperation assign = new JAsgOperation(expr.getSourceInfo(), assignedLocalRef, expr);
                this.currentRequest.append(new AppendBefore(returnStmt, assign.makeStatement()));
            }
            this.addFinallyBeforeBranching(returnStmt);
            return super.visit(returnStmt);
        }

        @Override
        public boolean visit(@Nonnull JLambda x) {
            return false;
        }

        @Override
        public boolean visit(@Nonnull JGoto gotoStmt) {
            if (this.isBranchingOutsideOfTryStatement(gotoStmt)) {
                this.addFinallyBeforeBranching(gotoStmt);
            }
            return super.visit(gotoStmt);
        }

        @Nonnull
        private InlinedFinallyMarker getMarkerOfTryCatchingExceptions(@Nonnull JNode stmt) {
            JNode previous = stmt;
            do {
                stmt = stmt.getParent();
                while (!(stmt instanceof JTryStatement) && !(stmt instanceof JMethodBody)) {
                    previous = stmt;
                    stmt = stmt.getParent();
                }
                if (!(stmt instanceof JTryStatement)) continue;
                if (((JTryStatement)stmt).getTryBlock() == previous) {
                    return new InlinedFinallyMarker((JTryStatement)stmt, false);
                }
                if (!((JTryStatement)stmt).getCatchBlocks().contains(previous) || ((JTryStatement)stmt).getFinallyBlock() == null) continue;
                return new InlinedFinallyMarker((JTryStatement)stmt, true);
            } while (!(stmt instanceof JMethodBody));
            return new InlinedFinallyMarker(null, false);
        }

        @Nonnull
        private JBlock getClonedBlock(@Nonnull JBlock finallyBlock) {
            JBlock clonedFinallyBlock = this.cloner.cloneStatement(this.finallyBlockToInsert);
            JNode parent = finallyBlock.getParent();
            assert (parent instanceof JTryStatement);
            InlinedFinallyMarker marker = this.getMarkerOfTryCatchingExceptions(parent);
            clonedFinallyBlock.addMarker(marker);
            for (Marker m : this.cloner.getClonedMarkers()) {
                if (!(m instanceof InlinedFinallyMarker)) continue;
                this.inlinedFinallyMarkers.add((InlinedFinallyMarker)m);
            }
            this.inlinedFinallyMarkers.add(marker);
            return clonedFinallyBlock;
        }

        private void addFinallyBeforeBranching(@Nonnull JStatement branchingStmt) {
            JBlock clonedFinallyBlock = this.getClonedBlock(this.finallyBlockToInsert);
            this.currentRequest.append(new AppendBefore(branchingStmt, clonedFinallyBlock));
        }

        private void addFinallyAtEndOfBlock(@Nonnull JStatementList block) {
            List<JStatement> blockStatements = block.getStatements();
            if (!blockStatements.isEmpty()) {
                boolean isLastStmtBranching;
                JStatement lastStmt = blockStatements.get(blockStatements.size() - 1);
                boolean bl = isLastStmtBranching = lastStmt instanceof JReturnStatement || lastStmt instanceof JThrowStatement || lastStmt instanceof JGoto && this.isBranchingOutsideOfTryStatement((JGoto)lastStmt);
                if (!isLastStmtBranching) {
                    JBlock clonedFinallyBlock = this.getClonedBlock(this.finallyBlockToInsert);
                    this.currentRequest.append(new PrependAfter(lastStmt, clonedFinallyBlock));
                }
            } else {
                JBlock clonedFinallyBlock = this.getClonedBlock(this.finallyBlockToInsert);
                this.currentRequest.append(new AppendStatement(block, clonedFinallyBlock));
            }
        }

        private void addCatchThrowableBlockWithFinallyStatements(@Nonnull JTryStatement tryStmt) {
            boolean hasCatchBlock = !tryStmt.getCatchBlocks().isEmpty();
            JBlock finallyBlock = tryStmt.getFinallyBlock();
            assert (finallyBlock != null);
            SourceInfo finallySourceInfo = finallyBlock.getSourceInfo();
            JBlock tryBlock = null;
            tryBlock = hasCatchBlock ? new JBlock(tryStmt.getTryBlock().getSourceInfo()) : tryStmt.getTryBlock();
            JMethodBody methodBody = (JMethodBody)this.currentMethod.getBody();
            assert (methodBody != null);
            JLocal local = new JLocal(finallySourceInfo, "t" + this.nameIndex++, this.throwableType, 4096, methodBody);
            JCatchBlock catchBlock = new JCatchBlock(finallySourceInfo, Collections.singletonList((JClass)this.throwableType), local);
            ArrayList<JCatchBlock> catchBlockList = new ArrayList<JCatchBlock>();
            catchBlockList.add(catchBlock);
            JTryStatement newTryStmt = new JTryStatement(tryStmt.getSourceInfo(), Collections.emptyList(), tryBlock, catchBlockList, null);
            JBlock clonedFinallyBlock = this.getClonedBlock(this.finallyBlockToInsert);
            this.currentRequest.append(new AppendStatement(catchBlock, clonedFinallyBlock));
            JLocalRef throwLocalRef = local.makeRef(finallySourceInfo);
            JThrowStatement throwStmt = new JThrowStatement(finallySourceInfo, throwLocalRef);
            this.currentRequest.append(new AppendStatement(catchBlock, throwStmt));
            for (InlinedFinallyMarker m : this.inlinedFinallyMarkers) {
                if (tryStmt != m.getTryStmt() || !m.isCatchIntoFinally() && hasCatchBlock) continue;
                m.setTryStmt(newTryStmt);
            }
            this.currentRequest.append(new Replace(tryStmt, newTryStmt));
            if (hasCatchBlock) {
                this.currentRequest.append(new AppendStatement(tryBlock, tryStmt));
            }
        }

        private boolean isBranchingOutsideOfTryStatement(@Nonnull JGoto gotoStatement) {
            JNode parent;
            for (parent = gotoStatement.getTargetBlock().getParent(); parent != this.tryStmt && !(parent instanceof JMethodBody); parent = parent.getParent()) {
            }
            return parent != this.tryStmt;
        }
    }

    private class JTryStatementVisitor
    extends JVisitor {
        @Nonnull
        private final Stack<TransformationRequest> requestStack = new Stack();
        @Nonnull
        private final JMethod currentMethod;
        @Nonnull
        private final List<InlinedFinallyMarker> inlinedFinallyMarkers = new ArrayList<InlinedFinallyMarker>();

        private JTryStatementVisitor(@Nonnull TransformationRequest trRequest, JMethod currentMethod) {
            this.requestStack.add(trRequest);
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean visit(@Nonnull JTryStatement tryStmt) {
            this.requestStack.add(new TransformationRequest(tryStmt));
            return super.visit(tryStmt);
        }

        @Override
        public void endVisit(@Nonnull JTryStatement tryStmt) {
            TransformationRequest request = this.requestStack.pop();
            request.commit();
            JBlock finallyBlock = tryStmt.getFinallyBlock();
            if (finallyBlock != null) {
                request = this.requestStack.peek();
                FinallyInliner finallyInliner = new FinallyInliner(tryStmt, FinallyRemover.this.throwableType, this.currentMethod, finallyBlock, request, this.inlinedFinallyMarkers);
                finallyInliner.inlineFinally();
                request.append(new Remove(finallyBlock));
            }
        }
    }
}

