/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums.opt;

import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.util.NamingTools;
import javax.annotation.Nonnull;

public class OptimizationUtil {
    private static final char ShorterPrefix = '-';
    @Nonnull
    private static final String LongerPrefix = "-get";
    @Nonnull
    private static final String Suffix = "SwitchesValues";

    public boolean isSyntheticSwitchMapInitializer(@Nonnull JMethod method) {
        String methodName = method.getName();
        int modifier = method.getModifier();
        return methodName.startsWith(LongerPrefix) && methodName.endsWith(Suffix) && method.getParams().isEmpty() && JModifier.isSynthetic(modifier) && JModifier.isPublic(modifier) && JModifier.isStatic(modifier) && method.getType().isSameType(JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray());
    }

    public boolean isSyntheticSwitchMapField(@Nonnull JField field) {
        String fieldName = field.getName();
        int modifier = field.getModifier();
        return fieldName.endsWith(Suffix) && JModifier.isSynthetic(modifier) && JModifier.isPrivate(modifier) && JModifier.isStatic(modifier) && field.getType().isSameType(JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray());
    }

    @Nonnull
    public static String getSyntheticSwitchMapInitializerName(@Nonnull JDefinedEnum enumType) {
        String enumName = BinaryQualifiedNameFormatter.getFormatter().getName(enumType);
        return NamingTools.getStrictNonSourceConflictingName("get" + enumName + Suffix);
    }

    @Nonnull
    public static String getSyntheticSwitchMapFieldName(@Nonnull JDefinedEnum enumType) {
        String enumName = BinaryQualifiedNameFormatter.getFormatter().getName(enumType);
        return NamingTools.getStrictNonSourceConflictingName(enumName + Suffix);
    }

    @Nonnull
    public static String getEnumNameFromSyntheticField(@Nonnull JField syntheticField) {
        String fieldName = syntheticField.getName().replace('-', '/');
        return "L" + fieldName.substring(1, fieldName.length() - Suffix.length()) + ";";
    }
}

