/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.booleanoperators;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JConditionalOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.booleanoperators.FallThroughMarker;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Removes conditional operator && and ||.")
@Name(value="ConditionalAndOrRemover")
@Constraint(need={JConditionalOperation.class})
@Transform(add={JConditionalExpression.class, JBooleanLiteral.class, FallThroughMarker.class}, remove={JConditionalOperation.class, ThreeAddressCodeForm.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ConditionalAndOrRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        BooleanExpressionSimplifierVisitor besv = new BooleanExpressionSimplifierVisitor(request);
        besv.accept(method);
        request.commit();
    }

    private static class BooleanExpressionSimplifierVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest transformationRequest;

        public BooleanExpressionSimplifierVisitor(@Nonnull TransformationRequest transformationRequest) {
            this.transformationRequest = transformationRequest;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binOp) {
            SourceInfo sourceInfo = binOp.getSourceInfo();
            JExpression lhs = binOp.getLhs();
            switch (binOp.getOp()) {
                case AND: {
                    JConditionalExpression replacingExpr = new JConditionalExpression(sourceInfo, lhs, binOp.getRhs(), new JBooleanLiteral(sourceInfo, false));
                    this.transformationRequest.append(new Replace(binOp, replacingExpr));
                    break;
                }
                case OR: {
                    JConditionalExpression replacingExpr = new JConditionalExpression(sourceInfo, lhs, new JBooleanLiteral(sourceInfo, true), binOp.getRhs());
                    replacingExpr.addMarker(new FallThroughMarker(FallThroughMarker.FallThroughEnum.ELSE));
                    this.transformationRequest.append(new Replace(binOp, replacingExpr));
                    break;
                }
            }
            return super.visit(binOp);
        }
    }
}

