/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JMethodNameLiteral;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reflection.MemberFinder;
import com.android.jack.reflection.MultipleMethodsFoundException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.ast.string.parameterrefiners.CommonStringParameterRefiner;
import com.android.jack.transformations.ast.string.parameterrefiners.StringParameterRefiner;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class, InitInNewArray.class})
@Transform(add={JMethodNameLiteral.class})
@Access(value=JSession.class)
public class GetMethodParameterRefiner
extends CommonStringParameterRefiner
implements StringParameterRefiner {
    @Nonnull
    private static final String GETMETHOD_METHOD_NAME = "getMethod";
    @Nonnull
    private final JMethodIdWide getMethodMethodId;

    public GetMethodParameterRefiner() {
        ArrayList<JType> parameterList = new ArrayList<JType>(2);
        parameterList.add(this.javaLangString);
        parameterList.add(this.javaLangClassArray);
        this.getMethodMethodId = this.javaLangClass.getMethodIdWide(GETMETHOD_METHOD_NAME, parameterList, MethodKind.INSTANCE_VIRTUAL);
    }

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) throws JMethodLookupException {
        if (call.getReceiverType().isSameType(this.javaLangClass) && call.getMethodId().equals(this.getMethodMethodId)) {
            assert (formatter.getName(call.getType()).equals("Ljava/lang/reflect/Method;"));
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    public JStringLiteral getExpressionToRefine(@Nonnull JMethodCall call) {
        assert (call.getArgs().size() == 2);
        return this.getExpressionToRefine(call, 0);
    }

    @Override
    @CheckForNull
    public JAbstractStringLiteral getRefinedExpression(@Nonnull JMethodCall call, @Nonnull JStringLiteral paramToRefine) {
        JMethod method;
        JMethodNameLiteral strMethodLiteral = null;
        String methodName = paramToRefine.getValue();
        JDefinedClassOrInterface type = this.getTypeFromClassLiteralExpression(call.getInstance());
        String methodSignature = this.getMethodSignature(call);
        if (type != null && methodSignature != null && (method = this.lookupMethod(type, methodSignature)) != null) {
            strMethodLiteral = new JMethodNameLiteral(paramToRefine.getSourceInfo(), method);
            assert (methodName.equals(strMethodLiteral.getValue()));
        }
        return strMethodLiteral;
    }

    @CheckForNull
    protected JMethod lookupMethod(@Nonnull JDefinedClassOrInterface type, @Nonnull String methodSignature) {
        JMethod foundMethod = null;
        try {
            foundMethod = MemberFinder.getMethod(type, methodSignature);
        }
        catch (MultipleMethodsFoundException multipleMethodsFoundException) {
            // empty catch block
        }
        return foundMethod;
    }

    @CheckForNull
    private String getMethodSignature(@Nonnull JMethodCall call) {
        JExpression instance = call.getInstance();
        assert (instance != null);
        List<JExpression> args = call.getArgs();
        assert (args.size() == 2);
        JExpression methodName = args.get(0);
        JExpression parameters = args.get(1);
        if (methodName instanceof JStringLiteral && parameters instanceof JNewArray) {
            StringBuilder sb = new StringBuilder(((JStringLiteral)methodName).getValue());
            sb.append("(");
            for (JExpression param : ((JNewArray)parameters).getInitializers()) {
                if (param instanceof JClassLiteral) {
                    sb.append(Jack.getLookupFormatter().getName(((JClassLiteral)param).getRefType()));
                    continue;
                }
                return null;
            }
            sb.append(")");
            return sb.toString();
        }
        return null;
    }
}

