/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldNameLiteral;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.reflection.MemberFinder;
import com.android.jack.reflection.MultipleFieldsFoundException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.string.parameterrefiners.CommonStringParameterRefiner;
import com.android.jack.transformations.ast.string.parameterrefiners.StringParameterRefiner;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
@Transform(add={JFieldNameLiteral.class})
@Access(value=JSession.class)
public class AtomicLongIntUpdaterParameterRefiner
extends CommonStringParameterRefiner
implements StringParameterRefiner {
    @Nonnull
    private final JClassOrInterface atomicIntegerFieldUpdater = (JClassOrInterface)Jack.getSession().getPhantomLookup().getType(CommonTypes.JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICINTEGERFIELDUPDATER);
    @Nonnull
    private final JClassOrInterface atomicLongFieldUpdater = (JClassOrInterface)Jack.getSession().getPhantomLookup().getType(CommonTypes.JAVA_UTIL_CONCURRENT_ATOMIC_ATOMICLONGFIELDUPDATER);

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) {
        JClassOrInterface receiverType = call.getReceiverType();
        return (this.isOrIsSubClassOf(receiverType, this.atomicIntegerFieldUpdater) || this.isOrIsSubClassOf(receiverType, this.atomicLongFieldUpdater)) && call.getMethodName().equals("newUpdater");
    }

    @Override
    @CheckForNull
    public JStringLiteral getExpressionToRefine(@Nonnull JMethodCall call) {
        assert (call.getArgs().size() == 2);
        return this.getExpressionToRefine(call, 1);
    }

    @Override
    @CheckForNull
    public JAbstractStringLiteral getRefinedExpression(@Nonnull JMethodCall call, @Nonnull JStringLiteral paramToRefine) {
        JFieldNameLiteral strFieldLiteral = null;
        JDefinedClassOrInterface type = this.getTypeFromClassLiteralExpression(call.getArgs().get(0));
        if (type != null) {
            String fieldName = paramToRefine.getValue();
            JField foundField = null;
            try {
                foundField = MemberFinder.getDirectField(type, fieldName);
            }
            catch (MultipleFieldsFoundException multipleFieldsFoundException) {
                // empty catch block
            }
            if (foundField != null) {
                strFieldLiteral = new JFieldNameLiteral(paramToRefine.getSourceInfo(), foundField);
                assert (fieldName.equals(strFieldLiteral.getValue()));
            }
        }
        return strFieldLiteral;
    }
}

