/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.ast.marker.ThisRefTypeInfo;
import com.android.jack.signature.GenericSignatureParser;
import com.android.jack.transformations.ast.string.GenericSignatureRefiner;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Use;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Split type generic signature into more specific string literals.")
@Name(value="TypeGenericSignatureSplitter")
@Constraint(need={GenericSignature.class})
@Use(value={GenericSignatureRefiner.class})
public class TypeGenericSignatureSplitter
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface declaredType) {
        CharSequence newSignature;
        ThisRefTypeInfo thisMarker;
        CharSequence newSignature2;
        GenericSignature marker = declaredType.getMarker(GenericSignature.class);
        if (marker != null && (newSignature2 = this.getSplittedSignature(marker.getGenericSignature())) != null) {
            marker.setGenericSignature(newSignature2);
        }
        if ((thisMarker = declaredType.getMarker(ThisRefTypeInfo.class)) != null && (newSignature = this.getSplittedSignature(thisMarker.getGenericSignature())) != null) {
            thisMarker.setGenericSignature(newSignature);
        }
    }

    @CheckForNull
    private CharSequence getSplittedSignature(@CheckForNull String oldSignature) {
        if (oldSignature == null || oldSignature.isEmpty()) {
            return null;
        }
        GenericSignatureRefiner parserActions = new GenericSignatureRefiner();
        GenericSignatureParser<JType> parser = new GenericSignatureParser<JType>(parserActions);
        parser.parseClassSignature(oldSignature);
        assert (parserActions.getNewSignature().toString().equals(oldSignature));
        return parserActions.getNewSignature();
    }
}

