/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeStringLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JLookupException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={JStringLiteral.class, OriginalNames.class})
@Transform(add={JTypeStringLiteral.class})
@Access(value=JSession.class)
public class StringLiteralRefinerVisitor
extends JVisitor {
    @Nonnull
    private static final String SRC_ARRAY_REPRESENTATION = "[]";
    @Nonnull
    private final TransformationRequest tr;
    @Nonnull
    private final JLookup lookup;

    public StringLiteralRefinerVisitor(@Nonnull TransformationRequest tr) {
        this.tr = tr;
        this.lookup = Jack.getSession().getLookup();
    }

    @Override
    public boolean visit(@Nonnull JStringLiteral stringLiteral) {
        String strValue = stringLiteral.getValue();
        boolean hasDot = strValue.contains(".");
        boolean hasSlash = strValue.contains("/");
        if (hasDot && hasSlash) {
            return false;
        }
        JType type = this.getTypeFromString(strValue);
        if (type != null) {
            this.tr.append(new Replace(stringLiteral, new JTypeStringLiteral(stringLiteral.getSourceInfo(), hasDot ? TypeName.Kind.SRC_QN : TypeName.Kind.BINARY_QN, type)));
        }
        return false;
    }

    @CheckForNull
    private JType getTypeFromString(@Nonnull String str) {
        String signatureName = this.getSignatureName(str);
        if (NamingTools.isTypeDescriptor(signatureName)) {
            try {
                JType type = this.lookup.getType(signatureName);
                return type;
            }
            catch (JLookupException jLookupException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    private String getSignatureName(@Nonnull String str) {
        StringBuilder signatureName = new StringBuilder();
        if (str.endsWith(SRC_ARRAY_REPRESENTATION)) {
            while (str.endsWith(SRC_ARRAY_REPRESENTATION)) {
                str = str.substring(0, str.length() - SRC_ARRAY_REPRESENTATION.length());
                signatureName.append('[');
            }
        }
        signatureName.append('L').append(str.replace('.', '/')).append(';');
        return signatureName.toString();
    }
}

