/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string;

import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.signature.GenericSignatureParser;
import com.android.jack.transformations.ast.string.GenericSignatureRefiner;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import javax.annotation.Nonnull;

@Description(value="Split method generic signature into more specific string literals.")
@Name(value="MethodGenericSignatureSplitter")
@Transform(modify={GenericSignature.class})
@Use(value={GenericSignatureRefiner.class})
public class MethodGenericSignatureSplitter
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        GenericSignature marker = method.getMarker(GenericSignature.class);
        if (marker != null) {
            String oldSignature = marker.getGenericSignature();
            GenericSignatureRefiner parserActions = new GenericSignatureRefiner();
            GenericSignatureParser<JType> parser = new GenericSignatureParser<JType>(parserActions);
            parser.parseMethodSignature(oldSignature);
            assert (parserActions.getNewSignature().toString().equals(oldSignature));
            marker.setGenericSignature(parserActions.getNewSignature());
        }
    }
}

