/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.inner.InnerAccessorGenerator;
import com.android.jack.transformations.ast.inner.NeedsDispatchAdjustment;
import com.android.jack.transformations.ast.inner.NeedsRethising;
import com.android.jack.transformations.ast.inner.ReferencedFromInnerClassMarker;
import com.android.jack.transformations.request.AddModifiers;
import com.android.jack.transformations.request.AppendMethodParam;
import com.android.jack.transformations.request.RemoveModifiers;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Changes collected fields visibility to package private,transforms collected methods to their uniquely named, package private versions.")
@Transform(add={NeedsDispatchAdjustment.class, JParameter.class, NeedsRethising.class}, modify={JMethod.class}, remove={ReferencedFromInnerClassMarker.class})
@Constraint(need={ReferencedFromInnerClassMarker.class})
@Filter(value={SourceTypeFilter.class})
public class ReferencedOuterFieldsExposer
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        if (type instanceof JDefinedInterface) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(type);
        ReferencedFromInnerClassMarker marker = type.getMarker(ReferencedFromInnerClassMarker.class);
        if (marker != null) {
            for (JField f : marker.getFields()) {
                tr.append(new RemoveModifiers(f, 2));
            }
            for (JMethod method : marker.getMethods()) {
                tr.append(new RemoveModifiers(method, 2));
                if (method instanceof JConstructor) continue;
                tr.append(new AddModifiers(method, 8));
                JMethodIdWide id = method.getMethodIdWide();
                assert (id.getMethods().size() == 1);
                if (id.getKind() == MethodKind.STATIC) continue;
                id.setKind(MethodKind.STATIC);
                id.addMarker(NeedsDispatchAdjustment.INSTANCE);
                JParameter thisParam = new JParameter(method.getSourceInfo(), InnerAccessorGenerator.THIS_PARAM_NAME, type, 4112, method);
                tr.append(new AppendMethodParam(method, thisParam));
                method.addMarker(NeedsRethising.INSTANCE);
            }
            type.removeMarker(ReferencedFromInnerClassMarker.class);
        }
        tr.commit();
    }
}

