/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.Jack;
import com.android.jack.annotations.DisableAccessorOptimization;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JSession;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.ast.inner.GetterMarker;
import com.android.jack.transformations.ast.inner.InnerAccessorGenerator;
import com.android.jack.transformations.ast.inner.ReferencedFromInnerClassMarker;
import com.android.jack.transformations.ast.inner.SetterMarker;
import com.android.jack.transformations.ast.inner.WrapperMarker;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Generate accessors for outer fields and methods in an inner class")
@Synchronized
@Transform(add={ReferencedFromInnerClassMarker.class, GetterMarker.class, SetterMarker.class, WrapperMarker.class, JMethodCall.class, JNewInstance.class, JNullLiteral.class, JExpressionStatement.class}, remove={ThreeAddressCodeForm.class, NewInstanceRemoved.class})
@Constraint(no={SideEffectOperation.class, JAlloc.class})
@Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JSession.class)
public class OptimizedInnerAccessorGenerator
extends InnerAccessorGenerator {
    @Nonnull
    private final JAnnotationType annotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableAccessorOptimization.class.getName()));

    @Nonnull
    private ReferencedFromInnerClassMarker getOrCreateRFICMarker(@Nonnull JDefinedClassOrInterface accessorClass) {
        ReferencedFromInnerClassMarker newMarker;
        ReferencedFromInnerClassMarker marker = accessorClass.getMarker(ReferencedFromInnerClassMarker.class);
        if (marker == null && (marker = accessorClass.addMarkerIfAbsent(newMarker = new ReferencedFromInnerClassMarker())) == null) {
            marker = newMarker;
        }
        return marker;
    }

    private void markAsReferenced(@Nonnull JDefinedClassOrInterface accessorClass, @Nonnull JField field) {
        ReferencedFromInnerClassMarker marker = this.getOrCreateRFICMarker(accessorClass);
        marker.addField(field);
    }

    @Override
    protected void handleOuterFieldWrite(@Nonnull TransformationRequest tr, @Nonnull JFieldRef fieldRef, @Nonnull JDefinedClassOrInterface accessorClass) {
        JField field = fieldRef.getFieldId().getField();
        assert (field != null);
        if (!(field.isPrivate() && field.getAnnotations(this.annotationType).isEmpty() && field.getEnclosingType().getAnnotations(this.annotationType).isEmpty())) {
            super.handleOuterFieldWrite(tr, fieldRef, accessorClass);
            return;
        }
        this.markAsReferenced(accessorClass, field);
    }

    @Override
    protected void handleOuterFieldRead(@Nonnull TransformationRequest tr, @Nonnull JFieldRef fieldRef, @Nonnull JDefinedClassOrInterface accessorClass) {
        JField field = fieldRef.getFieldId().getField();
        assert (field != null);
        if (!(field.isPrivate() && field.getAnnotations(this.annotationType).isEmpty() && field.getEnclosingType().getAnnotations(this.annotationType).isEmpty())) {
            super.handleOuterFieldRead(tr, fieldRef, accessorClass);
            return;
        }
        this.markAsReferenced(accessorClass, field);
    }

    @Override
    protected void handleOuterMethodCall(@Nonnull TransformationRequest tr, @Nonnull JMethodCall methodCall, @Nonnull JMethod method, @Nonnull JDefinedClassOrInterface accessorClass, boolean isSuper) {
        if (!method.isPrivate() || method.isNative() || !method.getAnnotations(this.annotationType).isEmpty() || !method.getEnclosingType().getAnnotations(this.annotationType).isEmpty()) {
            super.handleOuterMethodCall(tr, methodCall, method, accessorClass, isSuper);
            return;
        }
        ReferencedFromInnerClassMarker referencedMarker = this.getOrCreateRFICMarker(accessorClass);
        referencedMarker.addMethod(method);
    }
}

