/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.Options;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.inner.NeedsDispatchAdjustment;
import com.android.jack.transformations.ast.inner.NeedsRethising;
import com.android.jack.transformations.request.AppendArgument;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Fixes calls to methods marked by OptimizedInnerAccessorGenerator and, if required, transforms these methods bodies to use their last argument instead of 'this'.")
@Transform(add={JParameterRef.class}, modify={JNewInstance.class, JMethodCall.class}, remove={NeedsRethising.class})
@Constraint(need={NeedsDispatchAdjustment.class, NeedsRethising.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class MethodCallDispatchAdjuster
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        Adjuster visitor;
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        if (method.containsMarker(NeedsRethising.class)) {
            visitor = new RethisingAdjuster(tr, method);
            method.removeMarker(NeedsRethising.class);
        } else {
            visitor = new Adjuster(tr, method);
        }
        visitor.accept(method);
        tr.commit();
    }

    static class RethisingAdjuster
    extends Adjuster {
        @Nonnull
        private final JParameter thisParam;

        public RethisingAdjuster(@Nonnull TransformationRequest tr, @Nonnull JMethod currentMethod) {
            super(tr, currentMethod);
            this.thisParam = currentMethod.getParams().get(currentMethod.getParams().size() - 1);
        }

        @Override
        public boolean visit(@Nonnull JThisRef x) {
            JParameterRef replacement = this.thisParam.makeRef(x.getSourceInfo());
            replacement.addAllMarkers(x.getAllMarkers());
            this.tr.append(new Replace(x, replacement));
            return super.visit(x);
        }
    }

    static class Adjuster
    extends JVisitor {
        @Nonnull
        protected final TransformationRequest tr;
        @Nonnull
        private final JMethod currentMethod;

        public Adjuster(@Nonnull TransformationRequest tr, @Nonnull JMethod currentMethod) {
            this.tr = tr;
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean visit(@Nonnull JMethodCall methodCall) {
            JExpression instance;
            JMethodIdWide id = methodCall.getMethodId();
            if (id.containsMarker(NeedsDispatchAdjustment.class) && (instance = methodCall.getInstance()) != null) {
                this.tr.append(new Remove(instance));
                this.tr.append(new AppendArgument(methodCall, instance));
            }
            return super.visit(methodCall);
        }
    }
}

