/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.google.common.collect.Ordering;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.inner.GetterMarker;
import com.android.jack.transformations.ast.inner.InnerAccessor;
import com.android.jack.transformations.ast.inner.SetterMarker;
import com.android.jack.transformations.ast.inner.WrapperMarker;
import com.android.jack.transformations.request.AppendMethod;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.Comparator;
import javax.annotation.Nonnull;

@Description(value="Adds accessors for outer fields and methods in an inner class")
@Transform(add={GetterMarker.InnerAccessorGetter.class, SetterMarker.InnerAccessorSetter.class, WrapperMarker.InnerAccessorWrapper.class, InnerAccessor.class}, remove={GetterMarker.class, SetterMarker.class, WrapperMarker.class, ThreeAddressCodeForm.class})
@Constraint(need={GetterMarker.class, SetterMarker.class, WrapperMarker.class})
@Filter(value={SourceTypeFilter.class})
public class InnerAccessorAdder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        WrapperMarker wrapperMarker;
        SetterMarker setterMarker;
        int index;
        if (type instanceof JDefinedInterface) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(type);
        Ordering<JMethod> methodOrdering = Ordering.from(new Comparator<JMethod>(){

            @Override
            public int compare(JMethod m1, JMethod m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        GetterMarker getterMarker = type.getMarker(GetterMarker.class);
        if (getterMarker != null) {
            index = 0;
            for (JMethod m : methodOrdering.sortedCopy(getterMarker.getAllGetters())) {
                m.getMethodIdWide().setName(NamingTools.getNonSourceConflictingName("get") + index++);
                tr.append(new AppendMethod(type, m));
            }
            type.removeMarker(GetterMarker.class);
        }
        if ((setterMarker = type.getMarker(SetterMarker.class)) != null) {
            index = 0;
            for (JMethod m : methodOrdering.sortedCopy(setterMarker.getAllSetters())) {
                m.getMethodIdWide().setName(NamingTools.getNonSourceConflictingName("set") + index++);
                tr.append(new AppendMethod(type, m));
            }
            type.removeMarker(SetterMarker.class);
        }
        if ((wrapperMarker = type.getMarker(WrapperMarker.class)) != null) {
            index = 0;
            for (JMethod m : methodOrdering.sortedCopy(wrapperMarker.getAllWrappers())) {
                if (!(m instanceof JConstructor)) {
                    m.getMethodIdWide().setName(NamingTools.getNonSourceConflictingName("wrap") + index++);
                }
                tr.append(new AppendMethod(type, m));
            }
            type.removeMarker(WrapperMarker.class);
        }
        tr.commit();
    }
}

