/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Replaces assign into expression or statement by multi expression to remove read/write of the same expression.")
@Name(value="NestedAssignRemover")
@Constraint(need={JAsgOperation.class})
@Transform(add={JMultiExpression.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class}, remove={JAsgOperation.class, ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class NestedAssignRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor(method);
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;
        @Nonnull
        private final LocalVarCreator localVarCreator;

        public Visitor(JMethod method) {
            this.method = method;
            this.localVarCreator = new LocalVarCreator(method, "nestedAsg");
        }

        @Override
        public void endVisit(@Nonnull JBinaryOperation binOp) {
            if (binOp.getOp() == JBinaryOperator.ASG && binOp.isResultUsed()) {
                SourceInfo sourceInfo = binOp.getSourceInfo();
                TransformationRequest tr = new TransformationRequest(this.method);
                JExpression rhs = binOp.getRhs();
                JType rhsType = rhs.getType();
                JLocal tmp = this.localVarCreator.createTempLocal(rhsType, sourceInfo, tr);
                JAsgOperation asg1 = new JAsgOperation(sourceInfo, tmp.makeRef(sourceInfo), rhs);
                JAsgOperation asg2 = new JAsgOperation(sourceInfo, binOp.getLhs(), tmp.makeRef(sourceInfo));
                JLocalRef tmpRef = tmp.makeRef(sourceInfo);
                tr.append(new Replace(binOp, new JMultiExpression(sourceInfo, asg1, asg2, tmpRef)));
                tr.commit();
            }
        }
    }
}

