/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAddOperation;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPostfixDecOperation;
import com.android.jack.ir.ast.JPostfixIncOperation;
import com.android.jack.ir.ast.JPostfixOperation;
import com.android.jack.ir.ast.JPrefixDecOperation;
import com.android.jack.ir.ast.JPrefixIncOperation;
import com.android.jack.ir.ast.JPrefixOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSubOperation;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.SideEffectExtractor;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Remove increment and decrement.")
@Name(value="IncDecRemover")
@Transform(add={JAsgOperation.class, JAddOperation.class, JSubOperation.class, JMultiExpression.class, JArrayRef.class, JLocalRef.class, JIntLiteral.class, JFieldRef.class, JParameterRef.class, JDynamicCastOperation.class}, remove={JPrefixDecOperation.class, JPrefixIncOperation.class, JPostfixDecOperation.class, JPostfixIncOperation.class, ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class, SideEffectExtractor.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class IncDecRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        IncDecRemoverVisitor rca = new IncDecRemoverVisitor(tr);
        rca.accept(method);
        tr.commit();
    }

    private static class IncDecRemoverVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @CheckForNull
        private SideEffectExtractor extractor;
        @CheckForNull
        private LocalVarCreator lvCreator;

        private IncDecRemoverVisitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            JAbstractMethodBody body = method.getBody();
            if (body != null && body instanceof JMethodBody) {
                this.lvCreator = new LocalVarCreator(method, "idr");
                this.extractor = new SideEffectExtractor(this.lvCreator);
            }
            return super.visit(method);
        }

        @Override
        public void endVisit(@Nonnull JMethod x) {
            this.lvCreator = null;
            this.extractor = null;
            super.endVisit(x);
        }

        @Override
        public boolean visit(@Nonnull JUnaryOperation unary) {
            JBinaryOperator newOperator = null;
            switch (unary.getOp()) {
                case DEC: {
                    newOperator = JBinaryOperator.SUB;
                    break;
                }
                case INC: {
                    newOperator = JBinaryOperator.ADD;
                    break;
                }
            }
            if (newOperator != null) {
                SourceInfo sourceInfo = unary.getSourceInfo();
                JType binaryType = unary.getType();
                assert (this.extractor != null);
                JExpression argCopy = this.extractor.copyWithoutSideEffects(unary.getArg(), this.tr);
                if (unary instanceof JPostfixOperation) {
                    assert (this.lvCreator != null);
                    JLocal idr0 = this.lvCreator.createTempLocal(binaryType, sourceInfo, this.tr);
                    JLocalRef part1Lhs = idr0.makeRef(sourceInfo);
                    JAsgOperation part1 = new JAsgOperation(sourceInfo, part1Lhs, unary.getArg());
                    JBinaryOperation part2Rhs = JBinaryOperation.create(sourceInfo, newOperator, idr0.makeRef(sourceInfo), new JIntLiteral(sourceInfo, 1));
                    JAsgOperation part2 = new JAsgOperation(sourceInfo, argCopy, part2Rhs);
                    JLocalRef part3 = idr0.makeRef(sourceInfo);
                    JMultiExpression me = new JMultiExpression(sourceInfo, part1, part2, part3);
                    this.tr.append(new Replace(unary, me));
                } else {
                    assert (unary instanceof JPrefixOperation) : "Not yet supported";
                    JExpression rhs = JBinaryOperation.create(sourceInfo, newOperator, argCopy, new JIntLiteral(sourceInfo, 1));
                    JType unaryArgType = unary.getArg().getType();
                    if (unaryArgType == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || unaryArgType == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() || unaryArgType == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType()) {
                        rhs = new JDynamicCastOperation(sourceInfo, rhs, unaryArgType);
                    }
                    JAsgOperation newExpr = new JAsgOperation(sourceInfo, unary.getArg(), rhs);
                    this.tr.append(new Replace(unary, newExpr));
                }
            }
            return super.visit(unary);
        }
    }
}

