/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.UnassignedValues;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Stores expressions contained in a JExpressionStatement in a local variable")
@Transform(add={JAsgOperation.NonReusedAsg.class, JLocalRef.class}, remove={UnassignedValues.class})
@Constraint(no={SideEffectOperation.class})
@Use(value={LocalVarCreator.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ExpressionStatementLegalizer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr, method);
        visitor.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final LocalVarCreator lvCreator;

        public Visitor(@Nonnull TransformationRequest tr, @Nonnull JMethod method) {
            this.tr = tr;
            this.lvCreator = new LocalVarCreator(method, "all");
        }

        private boolean isLegal(@Nonnull JExpression expr) {
            if (expr.getType() == JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) {
                return true;
            }
            return expr instanceof JAsgOperation || expr instanceof JVariableRef || expr instanceof JMethodCall;
        }

        @Override
        public void endVisit(@Nonnull JExpressionStatement exprSt) {
            JExpression expr = exprSt.getExpr();
            JType type = expr.getType();
            if (!this.isLegal(expr)) {
                SourceInfo sourceInfo = exprSt.getSourceInfo();
                JLocal lv = this.lvCreator.createTempLocal(type, sourceInfo, this.tr);
                JAsgOperation asg = new JAsgOperation(sourceInfo, lv.makeRef(sourceInfo), expr);
                this.tr.append(new Replace(expr, asg));
            }
            super.endVisit(exprSt);
        }
    }
}

