/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.assertion;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JPrefixNotOperation;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.assertion.EnabledAssertionFeature;
import com.android.jack.transformations.ast.BooleanTestOutsideIf;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;

@Description(value="Transforms assert into a throw and if statement")
@Name(value="ForcedAssertionTransformer")
@Constraint(need={JAssertStatement.class})
@Transform(add={BooleanTestOutsideIf.class, JIfStatement.class, JThrowStatement.class, JPrefixNotOperation.class, JMethodCall.class, JBlock.class, JNewInstance.class, JExpressionStatement.class}, remove={JAssertStatement.class, ThreeAddressCodeForm.class, NewInstanceRemoved.class})
@Support(value={EnabledAssertionFeature.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class EnabledAssertionTransformer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JClass jlo = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);
    @Nonnull
    private final JClass assertionError = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_ASSERTION_ERROR);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public void endVisit(@Nonnull JAssertStatement assertSt) {
            TransformationRequest request = new TransformationRequest(assertSt);
            JExpression testExpression = assertSt.getTestExpr();
            JPrefixNotOperation notTestCondition = new JPrefixNotOperation(testExpression.getSourceInfo(), testExpression);
            ArrayList<JClass> ctorDescriptor = new ArrayList<JClass>();
            JExpression arg = assertSt.getArg();
            if (arg != null) {
                ctorDescriptor.add(EnabledAssertionTransformer.this.jlo);
            }
            JNewInstance newAssertionError = new JNewInstance(assertSt.getSourceInfo(), EnabledAssertionTransformer.this.assertionError, EnabledAssertionTransformer.this.assertionError.getOrCreateMethodIdWide("<init>", ctorDescriptor, MethodKind.INSTANCE_NON_VIRTUAL));
            if (arg != null) {
                newAssertionError.addArg(arg);
            }
            JThrowStatement throwAssertionError = new JThrowStatement(assertSt.getSourceInfo(), newAssertionError);
            JBlock blockThrow = new JBlock(assertSt.getSourceInfo());
            blockThrow.addStmt(throwAssertionError);
            JIfStatement ifNotTest = new JIfStatement(assertSt.getSourceInfo(), notTestCondition, blockThrow, null);
            request.append(new Replace(assertSt, ifNotTest));
            request.commit();
        }
    }
}

