/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.Options;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Remove unused locals.")
@Constraint(need={JLocal.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UnusedLocalRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
        JMethodBody body = (JMethodBody)method.getBody();
        assert (body != null);
        assert (visitor.localsToDelete != null);
        body.removeLocals(visitor.localsToDelete);
    }

    private static class Visitor
    extends JVisitor {
        @CheckForNull
        private List<JLocal> localsToDelete;

        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JMethodBody methodBody) {
            this.localsToDelete = new LinkedList<JLocal>(methodBody.getLocals());
            return !this.localsToDelete.isEmpty();
        }

        @Override
        public boolean visit(@Nonnull JVariableRef varRef) {
            JVariable variable = varRef.getTarget();
            assert (this.localsToDelete != null);
            this.localsToDelete.remove(variable);
            return super.visit(varRef);
        }
    }
}

