/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.Options;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.EmptyClinit;
import com.android.jack.transformations.InitializationExpression;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Remove empty clinit methods")
@Constraint(no={InitializationExpression.class})
@Transform(remove={EmptyClinit.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class EmptyClinitRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (JMethod.isClinit(method) && this.filter.accept(this.getClass(), method)) {
            JMethodBody body = (JMethodBody)method.getBody();
            assert (body != null);
            List<JStatement> stmts = body.getStatements();
            if (stmts.isEmpty() || stmts.get(0) instanceof JReturnStatement) {
                TransformationRequest tr = new TransformationRequest(method.getEnclosingType());
                tr.append(new Remove(method));
                tr.commit();
            }
        }
    }
}

