/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.statistics;

import com.android.jack.ir.ast.JField;
import com.android.jack.scheduling.feature.CompiledTypeStats;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;

@Description(value="Computes some statistics about compiled fields.")
@Support(value={CompiledTypeStats.class})
@Filter(value={SourceTypeFilter.class})
public class FieldStats
implements RunnableSchedulable<JField> {
    @Nonnull
    public static final StatisticId<Counter> INSTANCE_FIELDS_COUNT = new StatisticId<Counter>("jack.source.field.instance", "Instance fields", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> STATIC_FIELDS_COUNT = new StatisticId<Counter>("jack.source.field.static", "Static fields", CounterImpl.class, Counter.class);

    @Override
    public void run(@Nonnull JField field) {
        if (!field.getEnclosingType().isToEmit()) {
            return;
        }
        Tracer tracer = TracerFactory.getTracer();
        if (Modifier.isStatic(field.getModifier())) {
            tracer.getStatistic(STATIC_FIELDS_COUNT).incValue();
        } else {
            tracer.getStatistic(INSTANCE_FIELDS_COUNT).incValue();
        }
    }
}

