/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.statistics;

import com.android.jack.ir.ast.JSession;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Statistics about block and extra created block.")
@ValidOn(value={JSession.class})
public class BlockCountMarker
implements Marker {
    @Nonnegative
    private int existingBlockCount = 0;
    @Nonnegative
    private int extraIfThenBlockCount = 0;
    @Nonnegative
    private int extraIfElseBlockCount = 0;
    @Nonnegative
    private int extraLabeledStatementBlockCount = 0;
    @Nonnegative
    private int extraForBodyBlockCount = 0;
    @Nonnegative
    private int extraWhileBlockCount = 0;
    @Nonnegative
    private int extraImplicitForBlockCount = 0;

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    @Nonnegative
    public int getExistingBlockCount() {
        return this.existingBlockCount;
    }

    @Nonnegative
    public int getExtraBlockCount() {
        return this.extraIfThenBlockCount + this.extraIfElseBlockCount + this.extraLabeledStatementBlockCount + this.extraForBodyBlockCount + this.extraWhileBlockCount + this.extraImplicitForBlockCount;
    }

    public void addExistingBlockCount(@Nonnegative int existingBlockCount) {
        this.existingBlockCount += existingBlockCount;
    }

    @Nonnegative
    public int getExtraIfThenBlockCount() {
        return this.extraIfThenBlockCount;
    }

    @Nonnegative
    public int getExtraIfElseBlockCount() {
        return this.extraIfElseBlockCount;
    }

    @Nonnegative
    public int getExtraLabeledStatementBlockCount() {
        return this.extraLabeledStatementBlockCount;
    }

    @Nonnegative
    public int getExtraForBodyBlockCount() {
        return this.extraForBodyBlockCount;
    }

    @Nonnegative
    public int getExtraWhileBlockCount() {
        return this.extraWhileBlockCount;
    }

    public void addExtraIfThenBlockCount(@Nonnegative int extraIfThenBlockCount) {
        this.extraIfThenBlockCount += extraIfThenBlockCount;
    }

    public void addExtraIfElseBlockCount(@Nonnegative int extraIfElseBlockCount) {
        this.extraIfElseBlockCount += extraIfElseBlockCount;
    }

    public void addExtraLabeledStatementBlockCount(@Nonnegative int extraLabeledStatementBlockCount) {
        this.extraLabeledStatementBlockCount += extraLabeledStatementBlockCount;
    }

    public void addExtraForBodyBlockCount(@Nonnegative int extraForBodyBlockCount) {
        this.extraForBodyBlockCount += extraForBodyBlockCount;
    }

    public void addExtraWhileBlockCount(@Nonnegative int extraWhileBlockCount) {
        this.extraWhileBlockCount += extraWhileBlockCount;
    }

    @Nonnegative
    public int getExtraImplicitForBlockCount() {
        return this.extraImplicitForBlockCount;
    }

    public void addExtraImplicitForBlockCount(@Nonnegative int extraImplicitForBlockCount) {
        this.extraImplicitForBlockCount += extraImplicitForBlockCount;
    }
}

