/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.shrob.obfuscation.SubClassOrInterfaceMarker;
import com.android.sched.schedulable.Constraint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Constraint(need={SubClassOrInterfaceMarker.class})
public abstract class OneTimeHierarchyVisitor {
    @Nonnull
    private final List<JDefinedClassOrInterface> alreadyVisitedTypes = new ArrayList<JDefinedClassOrInterface>();

    public void visitSuperTypes(@Nonnull JDefinedClassOrInterface type) {
        JClass superClass = type.getSuperClass();
        if (superClass instanceof JDefinedClass) {
            JDefinedClass definedSuperClass = (JDefinedClass)superClass;
            this.visit(definedSuperClass);
            this.visitSuperTypes(definedSuperClass);
        }
        for (JInterface superInterface : type.getImplements()) {
            if (!(superInterface instanceof JDefinedInterface)) continue;
            JDefinedInterface definedSuperInterface = (JDefinedInterface)superInterface;
            this.visit(definedSuperInterface);
            this.visitSuperTypes(definedSuperInterface);
        }
    }

    public void visitSubTypes(@Nonnull JDefinedClassOrInterface type) {
        SubClassOrInterfaceMarker marker = type.getMarker(SubClassOrInterfaceMarker.class);
        if (marker != null) {
            Iterator<JDefinedClassOrInterface> it = marker.iterator();
            while (it.hasNext()) {
                this.visit(it.next());
            }
        }
    }

    public boolean visit(@Nonnull JDefinedClassOrInterface type) {
        if (!this.alreadyVisitedTypes.contains(type)) {
            this.alreadyVisitedTypes.add(type);
            return this.doAction(type);
        }
        return true;
    }

    public abstract boolean doAction(@Nonnull JDefinedClassOrInterface var1);
}

