/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.scheduling.marker.collector;

import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.marker.collector.SubTreeMarkers;
import com.android.sched.marker.Marker;
import com.android.sched.util.config.DefaultFactory;
import com.android.sched.util.config.ReflectDefaultCtorFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SubTreeMarkersCollector<T extends Marker> {
    @Nonnull
    private final DefaultFactory<? extends SubTreeMarkers<T>> subTreeMarkersFactory;
    @Nonnull
    private final Class<? extends SubTreeMarkers<T>> subTreeMarkersClass;

    public SubTreeMarkersCollector(@Nonnull Class<? extends SubTreeMarkers<T>> subTreeMarkersClass) {
        this(subTreeMarkersClass, new ReflectDefaultCtorFactory<SubTreeMarkers<T>>(subTreeMarkersClass, true));
    }

    public SubTreeMarkersCollector(@Nonnull Class<? extends SubTreeMarkers<T>> subTreeMarkersClass, @Nonnull DefaultFactory<? extends SubTreeMarkers<T>> subTreeMarkersFactory) {
        this.subTreeMarkersClass = subTreeMarkersClass;
        this.subTreeMarkersFactory = subTreeMarkersFactory;
    }

    @Nonnull
    public List<T> getSubTreeMarkers(@Nonnull JNode node) {
        return this.getOrCreateSubTreeMarkers(node).getAllMarkers();
    }

    @Nonnull
    public List<T> getSubTreeMarkersOnNextSibling(@Nonnull JNode node) {
        JNode parent = node.getParent();
        if (parent == null) {
            return new ArrayList();
        }
        SubTreeMarkers<T> parentCollectedMarkers = this.getOrCreateSubTreeMarkers(parent);
        SubTreeMarkers<T> collectedMarker = node.getMarker(this.subTreeMarkersClass);
        assert (collectedMarker != null);
        return parentCollectedMarkers.getAllMarkers().subList(collectedMarker.getAfterMarkerStartPosition(), parentCollectedMarkers.getPositionOfNestedMarkerEnd());
    }

    @Nonnull
    public List<T> getSubTreeMarkersOnPreviousSibling(@Nonnull JNode node) {
        JNode parent = node.getParent();
        if (parent == null) {
            return new ArrayList();
        }
        List<T> parentCollectedMarkers = this.getSubTreeMarkers(parent);
        SubTreeMarkers<T> collectedMarker = node.getMarker(this.subTreeMarkersClass);
        assert (collectedMarker != null);
        return parentCollectedMarkers.subList(0, collectedMarker.getBeforeMarkerEndPosition());
    }

    @Nonnull
    public List<T> getMarkersOnNodesLeftToPath(@Nonnull JNode subTreeRoot, @Nonnull JNode endNode) {
        JNode currentParent;
        this.getOrCreateSubTreeMarkers(subTreeRoot);
        ArrayList<T> markers = new ArrayList<T>();
        JNode currentNode = endNode;
        do {
            currentParent = currentNode.getParent();
            SubTreeMarkers<T> collectedMarker = currentNode.getMarker(this.subTreeMarkersClass);
            assert (collectedMarker != null);
            SubTreeMarkers<T> parentCollectedMarkers = currentParent.getMarker(this.subTreeMarkersClass);
            assert (parentCollectedMarkers != null);
            markers.addAll(parentCollectedMarkers.getAllMarkers().subList(0, collectedMarker.getBeforeMarkerEndPosition()));
        } while ((currentNode = currentParent) != subTreeRoot);
        return markers;
    }

    @Nonnull
    public List<T> getMarkersOnNodesRightToPath(@Nonnull JNode subTreeRoot, @Nonnull JNode endNode) {
        JNode currentParent;
        this.getOrCreateSubTreeMarkers(subTreeRoot);
        ArrayList<T> markers = new ArrayList<T>();
        JNode currentNode = endNode;
        do {
            currentParent = currentNode.getParent();
            SubTreeMarkers<T> collectedMarker = currentNode.getMarker(this.subTreeMarkersClass);
            assert (collectedMarker != null);
            SubTreeMarkers<T> parentCollectedMarkers = currentParent.getMarker(this.subTreeMarkersClass);
            assert (parentCollectedMarkers != null);
            markers.addAll(parentCollectedMarkers.getAllMarkers().subList(collectedMarker.getAfterMarkerStartPosition(), parentCollectedMarkers.getPositionOfNestedMarkerEnd()));
        } while ((currentNode = currentParent) != subTreeRoot);
        return markers;
    }

    @Nonnull
    private SubTreeMarkers<T> getOrCreateSubTreeMarkers(@Nonnull JNode node) {
        SubTreeMarkers<T> cm = node.getMarker(this.subTreeMarkersClass);
        if (cm == null) {
            new MarkerCollectorVisitor(node).accept(node);
            cm = node.getMarker(this.subTreeMarkersClass);
            assert (cm != null);
        }
        return cm;
    }

    private class MarkerCollectorVisitor
    extends JVisitor {
        @Nonnull
        private final JNode root;

        private MarkerCollectorVisitor(JNode root) {
            this.root = root;
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            SubTreeMarkers collectedMarkers = (SubTreeMarkers)node.getMarker(SubTreeMarkersCollector.this.subTreeMarkersClass);
            return collectedMarkers == null;
        }

        @Override
        public void endVisit(@Nonnull JNode node) {
            JNode parentNode;
            SubTreeMarkers newCollectedMarkers;
            SubTreeMarkers collectedMarkers = (SubTreeMarkers)node.getMarker(SubTreeMarkersCollector.this.subTreeMarkersClass);
            if (collectedMarkers == null && (collectedMarkers = node.addMarkerIfAbsent(newCollectedMarkers = (SubTreeMarkers)SubTreeMarkersCollector.this.subTreeMarkersFactory.create())) == null) {
                collectedMarkers = newCollectedMarkers;
            }
            if (!collectedMarkers.isCompletelyAnalyzed()) {
                collectedMarkers.endOfNestedMarkers();
                Object markerOfNode = node.getMarker(collectedMarkers.getClassOfCollectedMarkers());
                if (markerOfNode != null) {
                    collectedMarkers.addMarker(markerOfNode);
                }
            }
            if (this.root != node && (parentNode = node.getParent()) != null) {
                int beforeMarkerEndPosition;
                List markers = collectedMarkers.getAllMarkers();
                SubTreeMarkers parentCollectedMarkers = (SubTreeMarkers)parentNode.getMarker(SubTreeMarkersCollector.this.subTreeMarkersClass);
                if (parentCollectedMarkers == null) {
                    parentCollectedMarkers = (SubTreeMarkers)SubTreeMarkersCollector.this.subTreeMarkersFactory.create();
                    parentNode.addMarker(parentCollectedMarkers);
                    beforeMarkerEndPosition = 0;
                } else {
                    beforeMarkerEndPosition = parentCollectedMarkers.getAllMarkers().size();
                }
                collectedMarkers.setBeforeMarkerEndPosition(beforeMarkerEndPosition);
                collectedMarkers.setAfterMakerStartPosition(beforeMarkerEndPosition + markers.size());
                parentCollectedMarkers.addMarkers(markers);
            }
            super.endVisit(node);
        }

        @Override
        public boolean visit(@Nonnull JIfStatement jIf) {
            super.visit(jIf);
            this.accept(jIf.getIfExpr());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            super.visit(switchStmt);
            this.accept(switchStmt.getExpr());
            return false;
        }
    }
}

