/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JType;
import com.android.jack.preprocessor.BooleanExpression;
import com.android.jack.preprocessor.Context;
import com.android.jack.preprocessor.Expression;
import com.android.jack.preprocessor.NamePattern;
import com.android.jack.preprocessor.Scope;
import com.android.jack.preprocessor.SingleTypeScope;
import com.android.jack.preprocessor.SubContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class MethodFilter
implements Expression<Collection<JMethod>, Scope> {
    @Nonnull
    private final NamePattern name;
    @Nonnull
    private Expression<Boolean, HasModifier> modifierExpression = BooleanExpression.getTrue();
    @Nonnull
    private final Expression<Collection<? extends JType>, Scope> returnType;
    @Nonnull
    private List<Expression<Collection<? extends JType>, Scope>> argsType = Collections.emptyList();

    public MethodFilter(@Nonnull NamePattern name, @Nonnull Expression<Collection<? extends JType>, Scope> returnType) {
        this.name = name;
        this.returnType = returnType;
    }

    @Override
    @Nonnull
    public Collection<JMethod> eval(@Nonnull Scope scope, @Nonnull Context context) {
        ArrayList<JMethod> nodes = new ArrayList<JMethod>();
        for (JMethod method : scope.getNodesByName(JMethod.class, this.name)) {
            SingleTypeScope returnTypeContext;
            SubContext subContext;
            List<JParameter> params = method.getParams();
            if (params.size() != this.argsType.size() || !this.modifierExpression.eval(method, subContext = new SubContext(context)).booleanValue() || this.returnType.eval(returnTypeContext = new SingleTypeScope(method.getType()), subContext).isEmpty()) continue;
            boolean argsTypeMatched = true;
            Iterator<Expression<Collection<? extends JType>, Scope>> matchIter = this.argsType.iterator();
            Iterator<JParameter> paramIter = params.iterator();
            while (argsTypeMatched && paramIter.hasNext()) {
                argsTypeMatched = !matchIter.next().eval(new SingleTypeScope(paramIter.next().getType()), subContext).isEmpty();
            }
            if (!argsTypeMatched) continue;
            nodes.add(method);
            subContext.push();
        }
        return nodes;
    }

    public void addArg(@Nonnull Expression<Collection<? extends JType>, Scope> arg) {
        if (this.argsType.isEmpty()) {
            this.argsType = new ArrayList<Expression<Collection<? extends JType>, Scope>>();
        }
        this.argsType.add(arg);
    }

    public void setModifierExpression(@Nonnull Expression<Boolean, HasModifier> expression) {
        this.modifierExpression = expression;
    }
}

