/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.plugin;

import com.android.jack.Jack;
import com.android.jack.plugin.AcceptAll;
import com.android.jack.plugin.Last;
import com.android.jack.plugin.NotJackPluginException;
import com.android.jack.plugin.PluginFilter;
import com.android.jack.plugin.PluginNotFoundException;
import com.android.jack.plugin.PluginSelector;
import com.android.jack.plugin.v01.Plugin;
import com.android.sched.reflections.CompositeReflectionManager;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.config.id.ImplementationPropertyId;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class PluginManager {
    @Nonnull
    private static final ImplementationPropertyId<PluginSelector> PLUGIN_SELECTOR = ImplementationPropertyId.create("jack.plugin.selector", "Plugin selection policy", PluginSelector.class).addDefaultValue("last");
    @Nonnull
    private static final ImplementationPropertyId<PluginFilter> PLUGIN_FILTER = ImplementationPropertyId.create("jack.plugin.filter", "Plugin filter policy", PluginFilter.class).addDefaultValue("stable-only");
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final List<ServiceLoader<Plugin>> serviceLoaders = new LinkedList<ServiceLoader<Plugin>>();
    @Nonnull
    private final PluginFilter filter = new AcceptAll();
    @Nonnull
    private final PluginSelector selector = new Last();
    @Nonnull
    private final ConcurrentMap<String, Plugin> map = new ConcurrentHashMap<String, Plugin>();

    public void addPlugin(@Nonnull List<URL> urls) throws NotJackPluginException {
        this.addPlugin(urls.toArray(new URL[urls.size()]));
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public void addPlugin(@Nonnull URL[] urls) throws NotJackPluginException {
        this.addPlugin(new URLClassLoader(urls, PluginManager.class.getClassLoader()));
    }

    public void addPlugin(@Nonnull ClassLoader classLoader) throws NotJackPluginException {
        this.addPlugin(ServiceLoader.load(Plugin.class, classLoader));
    }

    public void addPlugin(@Nonnull ServiceLoader<Plugin> serviceLoader) throws NotJackPluginException {
        if (!serviceLoader.iterator().hasNext()) {
            throw new NotJackPluginException();
        }
        this.serviceLoaders.add(serviceLoader);
    }

    @Nonnull
    public Plugin loadPlugin(@Nonnull String name) throws PluginNotFoundException {
        Plugin plugin = (Plugin)this.map.get(name);
        if (plugin == null) {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            for (ServiceLoader<Plugin> serviceLoader : this.serviceLoaders) {
                for (Plugin candidate : serviceLoader) {
                    if (!candidate.getCanonicalName().equals(name)) continue;
                    if (candidate.isCompatibileWithJack(Jack.getVersion())) {
                        if (!this.filter.accept(candidate)) continue;
                        plugins.add(candidate);
                        continue;
                    }
                    logger.log(Level.INFO, "For plugin ''{0}'', rejected version {1} because not compatible with Jack version {2}", new Object[]{candidate.getCanonicalName(), candidate.getVersion().getVersion(), Jack.getVersion().getVersion()});
                }
            }
            if (plugins.isEmpty()) {
                throw new PluginNotFoundException(name);
            }
            Plugin newPlugin = this.selector.select(plugins);
            plugin = this.map.putIfAbsent(name, newPlugin);
            if (plugin == null) {
                plugin = newPlugin;
            }
        }
        assert (plugin != null);
        return plugin;
    }

    @Nonnull
    public Collection<Plugin> getPlugins() {
        return this.map.values();
    }

    public boolean hasPlugins() {
        return !this.map.isEmpty();
    }

    @Nonnull
    public ReflectionManager getReflectionManager(@Nonnull ReflectionManager primary) {
        if (this.getPlugins().size() == 0) {
            return primary;
        }
        CompositeReflectionManager composite = new CompositeReflectionManager();
        composite.addReflectionManager(primary);
        for (Plugin plugin : this.getPlugins()) {
            composite.addReflectionManager(plugin.getReflectionManager());
        }
        return composite;
    }

    @Nonnull
    public Collection<Plugin> getAvailablePlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (ServiceLoader<Plugin> serviceLoader : this.serviceLoaders) {
            for (Plugin plugin : serviceLoader) {
                plugins.add(plugin);
            }
        }
        return plugins;
    }
}

