/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.field;

import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.analysis.common.ReachabilityAnalyzer;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.google.common.collect.HashMultimap;
import com.android.jack.google.common.collect.Multimap;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.OptimizerUtils;
import com.android.jack.optimizations.valuepropagation.field.FieldSingleValueMarker;
import com.android.jack.optimizations.valuepropagation.field.FvpSchedulable;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@Description(value="Field value propagation, field value collection")
@Constraint(need={ControlFlowGraph.class, UseDefsMarker.class})
@Transform(add={FieldSingleValueMarker.class})
@Access(value=JDefinedClassOrInterface.class)
@Name(value="FieldValuePropagation: CollectFieldAssignments")
public class FvpCollectFieldAssignments
extends FvpSchedulable
implements RunnableSchedulable<JMethod> {
    private void analyzeRegularMethod(@Nonnull JMethod method) {
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock block : cfg.getNodes()) {
            for (JStatement stmt : block.getStatements()) {
                JField field;
                JAsgOperation assignment;
                JExpression lhs;
                JExpression expr;
                if (!(stmt instanceof JExpressionStatement) || !((expr = ((JExpressionStatement)stmt).getExpr()) instanceof JAsgOperation) || !((lhs = (assignment = (JAsgOperation)expr).getLhs()) instanceof JFieldRef) || (field = ((JFieldRef)lhs).getFieldId().getField()) == null || !field.getEnclosingType().isToEmit()) continue;
                FieldSingleValueMarker.markValue(field, assignment.getRhs());
            }
        }
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (!method.isAbstract() && !method.isNative()) {
            if (OptimizerUtils.isConstructor(method)) {
                new ConstructorAnalyzer(method).analyze();
            } else {
                this.analyzeRegularMethod(method);
            }
        }
    }

    private static class ConstructorAnalyzer
    extends ReachabilityAnalyzer<Multimap<JField, JExpression>> {
        @Nonnull
        final Multimap<JField, JExpression> defaultState = HashMultimap.create();
        @Nonnull
        private final JMethod constructor;

        ConstructorAnalyzer(@Nonnull JMethod constructor) {
            this.constructor = constructor;
            for (JField field : constructor.getEnclosingType().getFields()) {
                FieldSingleValueMarker marker;
                if (field.isStatic() != constructor.isStatic() || (marker = FieldSingleValueMarker.getOrCreate(field)) == null) continue;
                this.defaultState.put(field, FvpSchedulable.createDefaultValue(field));
            }
        }

        @Override
        @Nonnull
        public ControlFlowGraph getCfg() {
            ControlFlowGraph cfg = this.constructor.getMarker(ControlFlowGraph.class);
            assert (cfg != null);
            return cfg;
        }

        @Override
        @Nonnull
        protected Multimap<JField, JExpression> newState(boolean entry) {
            return entry ? this.cloneState(this.defaultState) : HashMultimap.create();
        }

        @Override
        @Nonnull
        protected Multimap<JField, JExpression> cloneState(@Nonnull Multimap<JField, JExpression> state) {
            return HashMultimap.create(state);
        }

        @Override
        protected void copyState(@Nonnull Multimap<JField, JExpression> src, @Nonnull Multimap<JField, JExpression> dest) {
            dest.clear();
            dest.putAll(src);
        }

        @Override
        protected void mergeState(@Nonnull Multimap<JField, JExpression> state, @Nonnull Multimap<JField, JExpression> otherState) {
            state.putAll(otherState);
        }

        @Override
        protected void processStatement(@Nonnull Multimap<JField, JExpression> outBs, @Nonnull JStatement stmt) {
            if (stmt instanceof JExpressionStatement) {
                JExpression expr = ((JExpressionStatement)stmt).getExpr();
                if (expr instanceof JAsgOperation) {
                    JAsgOperation assignment = (JAsgOperation)expr;
                    JExpression lhs = assignment.getLhs();
                    if (lhs instanceof JFieldRef) {
                        JFieldRef fieldRef = (JFieldRef)lhs;
                        JField field = fieldRef.getFieldId().getField();
                        if (field == null || !field.getEnclosingType().isToEmit()) {
                            return;
                        }
                        JExpression expression = assignment.getRhs();
                        if (this.defaultState.containsKey(field) && (field.isStatic() || fieldRef.getInstance() instanceof JThisRef)) {
                            outBs.removeAll(field);
                            outBs.put(field, expression);
                        } else {
                            FieldSingleValueMarker.markValue(field, expression);
                        }
                    }
                } else if (expr instanceof JMethodCall && !this.constructor.isStatic() && OptimizerUtils.isConstructorDelegation((JMethodCall)expr, (JConstructor)this.constructor)) {
                    Iterator<Map.Entry<JField, JExpression>> iterator = outBs.entries().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<JField, JExpression> entry = iterator.next();
                        JExpression value = entry.getValue();
                        if (value instanceof JValueLiteral && ((JValueLiteral)value).isTypeValue()) {
                            iterator.remove();
                            continue;
                        }
                        entry.setValue(expr);
                    }
                }
            }
        }

        @Override
        protected void finalize(@Nonnull List<Multimap<JField, JExpression>> in, @Nonnull List<Multimap<JField, JExpression>> out, @Nonnull List<Multimap<JField, JExpression>> outException) {
            Object exitBlockState = this.newState(false);
            this.recalculateInSet((BasicBlock)this.getCfg().getExitNode(), true, exitBlockState, out, outException);
            for (Map.Entry entry : exitBlockState.asMap().entrySet()) {
                assert (((JField)entry.getKey()).isStatic() == this.constructor.isStatic());
                FieldSingleValueMarker.markValues((JField)entry.getKey(), entry.getValue());
            }
        }
    }
}

