/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.ir.ast.JMethod;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import com.android.jack.optimizations.common.SimpleLiteralValueListTracker;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Represents a set of call arguments this method can be called with")
@ValidOn(value={JMethod.class})
public class MethodCallArgumentsMarker
implements Marker {
    @Nonnull
    private final SimpleLiteralValueListTracker args;

    private MethodCallArgumentsMarker(@Nonnegative int size) {
        this.args = new SimpleLiteralValueListTracker(size);
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError();
    }

    public static void markArgValues(@Nonnull JMethod method, @Nonnull LiteralValueListTracker tracker) {
        MethodCallArgumentsMarker marker = method.getMarker(MethodCallArgumentsMarker.class);
        if (marker == null) {
            marker = new MethodCallArgumentsMarker(tracker.size());
            method.addMarker(marker);
        }
        marker.args.updateWith(tracker);
    }

    @CheckForNull
    public static LiteralValueListTracker getTrackerAndRemoveMarker(@Nonnull JMethod method) {
        MethodCallArgumentsMarker marker = method.removeMarker(MethodCallArgumentsMarker.class);
        return marker == null ? null : marker.args;
    }
}

