/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.ir.ast.JMethod;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.Nonnull;

@Description(value="Marker records the 'effectively final' flag on methods.")
@ValidOn(value={JMethod.class})
public enum EffectivelyFinalMethodMarker implements Marker
{
    Final;


    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    public static boolean isEffectivelyFinal(@Nonnull JMethod method) {
        return method.getMarker(EffectivelyFinalMethodMarker.class) != null;
    }

    public static void markAsEffectivelyFinal(@Nonnull JMethod method) {
        if (!EffectivelyFinalMethodMarker.isEffectivelyFinal(method)) {
            method.addMarker(Final);
        }
    }
}

