/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.ir.ast.JField;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.Nonnull;

@Description(value="Marker records the 'effectively final' flag on fields.")
@ValidOn(value={JField.class})
public enum EffectivelyFinalFieldMarker implements Marker
{
    Final;


    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    public static boolean isEffectivelyFinal(@Nonnull JField field) {
        return field.getMarker(EffectivelyFinalFieldMarker.class) != null;
    }

    public static void markAsEffectivelyFinal(@Nonnull JField field) {
        if (!EffectivelyFinalFieldMarker.isEffectivelyFinal(field)) {
            field.addMarker(Final);
        }
    }
}

