/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JNumberLiteral;
import com.android.jack.ir.ast.JPrefixNotOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JUnaryOperator;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.Number;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.ImplicitCast;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Tag;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Expressions simplifier")
@Constraint(no={ImplicitCast.class, JCastOperation.WithIntersectionType.class}, need={ThreeAddressCodeForm.class})
@Transform(add={ExpressionsSimplified.class, JPrefixNotOperation.class, JBooleanLiteral.class, JIntLiteral.class, JLongLiteral.class, JDoubleLiteral.class, JFloatLiteral.class, JByteLiteral.class, JShortLiteral.class, JCharLiteral.class})
@Support(value={Optimizations.ExpressionSimplifier.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ExpressionSimplifier
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    private final boolean enableNullInstanceOf = ThreadConfig.get(Optimizations.ENABLE_NULL_INSTANCEOF);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Simplifier s = new Simplifier();
        s.accept(method);
    }

    class Simplifier
    extends JVisitor {
        @CheckForNull
        private JMethod currentMethod;

        Simplifier() {
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            this.currentMethod = method;
            return super.visit(method);
        }

        @Override
        public void endVisit(@Nonnull JCastOperation cast) {
            JExpression castedExpr = cast.getExpr();
            if (castedExpr instanceof JNumberLiteral && cast.getType() instanceof JPrimitiveType) {
                SourceInfo si = cast.getSourceInfo();
                Number numberValue = ((JNumberLiteral)((Object)castedExpr)).getNumber();
                JValueLiteral simplifiedExpr = this.refineCst(si, numberValue, ((JPrimitiveType)cast.getType()).getPrimitiveTypeEnum());
                assert (this.currentMethod != null);
                TransformationRequest tr = new TransformationRequest(this.currentMethod);
                tr.append(new Replace(cast, simplifiedExpr));
                tr.commit();
            }
        }

        @Override
        public void endVisit(@Nonnull JConditionalExpression jconditional) {
            JExpression condition = jconditional.getIfTest();
            if (condition instanceof JBooleanLiteral) {
                assert (this.currentMethod != null);
                TransformationRequest tr = new TransformationRequest(this.currentMethod);
                if (((JBooleanLiteral)condition).getValue()) {
                    tr.append(new Replace(jconditional, jconditional.getThenExpr()));
                } else {
                    tr.append(new Replace(jconditional, jconditional.getElseExpr()));
                }
                tr.commit();
            }
        }

        @Override
        public void endVisit(@Nonnull JInstanceOf instanceOf) {
            JExpression expr;
            if (ExpressionSimplifier.this.enableNullInstanceOf && ((expr = instanceOf.getExpr()) instanceof JNullLiteral || this.isCastOfNull(expr))) {
                assert (this.currentMethod != null);
                TransformationRequest tr = new TransformationRequest(this.currentMethod);
                tr.append(new Replace(instanceOf, new JBooleanLiteral(instanceOf.getSourceInfo(), false)));
                tr.commit();
            }
        }

        private boolean isCastOfNull(@Nonnull JExpression expr) {
            return expr instanceof JCastOperation && ((JCastOperation)expr).getExpr() instanceof JNullLiteral;
        }

        @Override
        public void endVisit(@Nonnull JUnaryOperation unaryExpr) {
            JValueLiteral simplifiedExpr = null;
            JExpression arg = unaryExpr.getArg();
            if (arg instanceof JValueLiteral) {
                SourceInfo si = unaryExpr.getSourceInfo();
                if (arg instanceof JIntegralConstant32) {
                    int value = ((JIntegralConstant32)((Object)arg)).getIntValue();
                    switch (unaryExpr.getOp()) {
                        case BIT_NOT: {
                            simplifiedExpr = new JIntLiteral(si, ~value);
                            break;
                        }
                        case NEG: {
                            simplifiedExpr = new JIntLiteral(si, -value);
                            break;
                        }
                    }
                } else if (arg instanceof JLongLiteral) {
                    long value = ((JLongLiteral)arg).getValue();
                    switch (unaryExpr.getOp()) {
                        case BIT_NOT: {
                            simplifiedExpr = new JLongLiteral(si, value ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case NEG: {
                            simplifiedExpr = new JLongLiteral(si, -value);
                            break;
                        }
                    }
                } else if (arg instanceof JDoubleLiteral && unaryExpr.getOp() == JUnaryOperator.NEG) {
                    simplifiedExpr = new JDoubleLiteral(si, -((JDoubleLiteral)arg).getValue());
                } else if (arg instanceof JFloatLiteral && unaryExpr.getOp() == JUnaryOperator.NEG) {
                    simplifiedExpr = new JFloatLiteral(si, -((JFloatLiteral)arg).getValue());
                } else if (arg instanceof JBooleanLiteral && unaryExpr.getOp() == JUnaryOperator.NOT) {
                    simplifiedExpr = new JBooleanLiteral(si, !((JBooleanLiteral)arg).getValue());
                }
            }
            if (simplifiedExpr != null) {
                assert (this.currentMethod != null);
                TransformationRequest tr = new TransformationRequest(this.currentMethod);
                tr.append(new Replace(unaryExpr, simplifiedExpr));
                tr.commit();
            }
            super.endVisit(unaryExpr);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void endVisit(@Nonnull JBinaryOperation binaryExpr) {
            void var6_98;
            block113: {
                JBinaryOperator op;
                SourceInfo si;
                JExpression rhs;
                JExpression lhs;
                block117: {
                    block116: {
                        block115: {
                            block114: {
                                block112: {
                                    lhs = binaryExpr.getLhs();
                                    rhs = binaryExpr.getRhs();
                                    si = binaryExpr.getSourceInfo();
                                    op = binaryExpr.getOp();
                                    Object var6_6 = null;
                                    if (!(lhs instanceof JNullLiteral) || !(rhs instanceof JNullLiteral)) break block112;
                                    switch (op) {
                                        case NEQ: {
                                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, false);
                                            break block113;
                                        }
                                        case EQ: {
                                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, true);
                                            break block113;
                                        }
                                        default: {
                                            throw new AssertionError((Object)"Unsupported operator");
                                        }
                                    }
                                }
                                if (!(lhs instanceof JBooleanLiteral) || !(rhs instanceof JBooleanLiteral)) break block114;
                                boolean lhsValue = ((JBooleanLiteral)lhs).getValue();
                                boolean rhsValue = ((JBooleanLiteral)rhs).getValue();
                                switch (op) {
                                    case NEQ: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue != rhsValue);
                                        break;
                                    }
                                    case EQ: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue == rhsValue);
                                        break;
                                    }
                                    case AND: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue && rhsValue);
                                        break;
                                    }
                                    case OR: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue || rhsValue);
                                        break;
                                    }
                                    case BIT_AND: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue & rhsValue);
                                        break;
                                    }
                                    case BIT_OR: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue | rhsValue);
                                        break;
                                    }
                                    case BIT_XOR: {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue ^ rhsValue);
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)"Unsupported operator");
                                    }
                                }
                                break block113;
                            }
                            if (!(lhs instanceof JBooleanLiteral)) break block115;
                            switch (op) {
                                case AND: {
                                    if (((JBooleanLiteral)lhs).getValue()) {
                                        JExpression jExpression = rhs;
                                        break;
                                    }
                                    JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, false);
                                    break;
                                }
                                case OR: {
                                    if (((JBooleanLiteral)lhs).getValue()) {
                                        JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, true);
                                        break;
                                    }
                                    JExpression jExpression = rhs;
                                    break;
                                }
                                case EQ: {
                                    if (((JBooleanLiteral)lhs).getValue()) {
                                        JExpression jExpression = rhs;
                                        break;
                                    }
                                    if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                    JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, rhs);
                                    break;
                                }
                                case NEQ: {
                                    if (((JBooleanLiteral)lhs).getValue()) {
                                        if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                        JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, rhs);
                                        break;
                                    }
                                    JExpression jExpression = rhs;
                                    break;
                                }
                                case BIT_AND: {
                                    if (!((JBooleanLiteral)lhs).getValue()) break;
                                    JExpression jExpression = rhs;
                                    break;
                                }
                                case BIT_OR: {
                                    if (((JBooleanLiteral)lhs).getValue()) break;
                                    JExpression jExpression = rhs;
                                    break;
                                }
                                case BIT_XOR: {
                                    if (((JBooleanLiteral)lhs).getValue()) {
                                        if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                        JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, rhs);
                                        break;
                                    }
                                    JExpression jExpression = rhs;
                                    break;
                                }
                            }
                            break block113;
                        }
                        if (!(rhs instanceof JBooleanLiteral)) break block116;
                        switch (op) {
                            case AND: {
                                if (!((JBooleanLiteral)rhs).getValue()) break;
                                JExpression jExpression = lhs;
                                break;
                            }
                            case OR: {
                                if (((JBooleanLiteral)rhs).getValue()) break;
                                JExpression jExpression = lhs;
                                break;
                            }
                            case EQ: {
                                if (((JBooleanLiteral)rhs).getValue()) {
                                    JExpression jExpression = lhs;
                                    break;
                                }
                                if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, lhs);
                                break;
                            }
                            case NEQ: {
                                if (((JBooleanLiteral)rhs).getValue()) {
                                    if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                    JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, lhs);
                                    break;
                                }
                                JExpression jExpression = lhs;
                                break;
                            }
                            case BIT_AND: {
                                if (!((JBooleanLiteral)rhs).getValue()) break;
                                JExpression jExpression = lhs;
                                break;
                            }
                            case BIT_OR: {
                                if (((JBooleanLiteral)rhs).getValue()) break;
                                JExpression jExpression = lhs;
                                break;
                            }
                            case BIT_XOR: {
                                if (((JBooleanLiteral)rhs).getValue()) {
                                    if (!(binaryExpr.getParent() instanceof JIfStatement)) break;
                                    JPrefixNotOperation jPrefixNotOperation = new JPrefixNotOperation(si, lhs);
                                    break;
                                }
                                JExpression jExpression = lhs;
                                break;
                            }
                        }
                        break block113;
                    }
                    if (!(lhs instanceof JIntegralConstant32) || !(rhs instanceof JIntegralConstant32)) break block117;
                    int lhsValue = ((JIntegralConstant32)((Object)lhs)).getIntValue();
                    int rhsValue = ((JIntegralConstant32)((Object)rhs)).getIntValue();
                    switch (op) {
                        case ADD: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue + rhsValue);
                            break;
                        }
                        case SUB: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue - rhsValue);
                            break;
                        }
                        case MUL: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue * rhsValue);
                            break;
                        }
                        case DIV: {
                            if (rhsValue != 0) {
                                JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue / rhsValue);
                                break;
                            }
                            break block113;
                        }
                        case MOD: {
                            if (rhsValue != 0) {
                                JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue % rhsValue);
                                break;
                            }
                            break block113;
                        }
                        case SHL: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue << rhsValue);
                            break;
                        }
                        case SHR: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue >> rhsValue);
                            break;
                        }
                        case SHRU: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue >>> rhsValue);
                            break;
                        }
                        case LT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue < rhsValue);
                            break;
                        }
                        case LTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue <= rhsValue);
                            break;
                        }
                        case GT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue > rhsValue);
                            break;
                        }
                        case GTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue >= rhsValue);
                            break;
                        }
                        case EQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue == rhsValue);
                            break;
                        }
                        case NEQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue != rhsValue);
                            break;
                        }
                        case BIT_AND: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue & rhsValue);
                            break;
                        }
                        case BIT_OR: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue | rhsValue);
                            break;
                        }
                        case BIT_XOR: {
                            JIntLiteral jIntLiteral = new JIntLiteral(si, lhsValue ^ rhsValue);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unsupported operator");
                        }
                    }
                    break block113;
                }
                if (lhs instanceof JFloatLiteral && rhs instanceof JFloatLiteral) {
                    float lhsValue = ((JFloatLiteral)lhs).getValue();
                    float rhsValue = ((JFloatLiteral)rhs).getValue();
                    switch (op) {
                        case ADD: {
                            JFloatLiteral jFloatLiteral = new JFloatLiteral(si, lhsValue + rhsValue);
                            break;
                        }
                        case SUB: {
                            JFloatLiteral jFloatLiteral = new JFloatLiteral(si, lhsValue - rhsValue);
                            break;
                        }
                        case MUL: {
                            JFloatLiteral jFloatLiteral = new JFloatLiteral(si, lhsValue * rhsValue);
                            break;
                        }
                        case DIV: {
                            JFloatLiteral jFloatLiteral = new JFloatLiteral(si, lhsValue / rhsValue);
                            break;
                        }
                        case MOD: {
                            JFloatLiteral jFloatLiteral = new JFloatLiteral(si, lhsValue % rhsValue);
                            break;
                        }
                        case LT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue < rhsValue);
                            break;
                        }
                        case LTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue <= rhsValue);
                            break;
                        }
                        case GT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue > rhsValue);
                            break;
                        }
                        case GTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue >= rhsValue);
                            break;
                        }
                        case EQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue == rhsValue);
                            break;
                        }
                        case NEQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue != rhsValue);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unsupported operator");
                        }
                    }
                } else if (lhs instanceof JDoubleLiteral && rhs instanceof JDoubleLiteral) {
                    double lhsValue = ((JDoubleLiteral)lhs).getValue();
                    double rhsValue = ((JDoubleLiteral)rhs).getValue();
                    switch (op) {
                        case ADD: {
                            JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(si, lhsValue + rhsValue);
                            break;
                        }
                        case SUB: {
                            JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(si, lhsValue - rhsValue);
                            break;
                        }
                        case MUL: {
                            JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(si, lhsValue * rhsValue);
                            break;
                        }
                        case DIV: {
                            JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(si, lhsValue / rhsValue);
                            break;
                        }
                        case MOD: {
                            JDoubleLiteral jDoubleLiteral = new JDoubleLiteral(si, lhsValue % rhsValue);
                            break;
                        }
                        case LT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue < rhsValue);
                            break;
                        }
                        case LTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue <= rhsValue);
                            break;
                        }
                        case GT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue > rhsValue);
                            break;
                        }
                        case GTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue >= rhsValue);
                            break;
                        }
                        case EQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue == rhsValue);
                            break;
                        }
                        case NEQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue != rhsValue);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unsupported operator");
                        }
                    }
                } else if (lhs instanceof JLongLiteral && rhs instanceof JLongLiteral) {
                    long lhsValue = ((JLongLiteral)lhs).getValue();
                    long rhsValue = ((JLongLiteral)rhs).getValue();
                    switch (op) {
                        case ADD: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue + rhsValue);
                            break;
                        }
                        case SUB: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue - rhsValue);
                            break;
                        }
                        case MUL: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue * rhsValue);
                            break;
                        }
                        case DIV: {
                            if (rhsValue == 0L) break;
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue / rhsValue);
                            break;
                        }
                        case MOD: {
                            if (rhsValue == 0L) break;
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue % rhsValue);
                            break;
                        }
                        case SHL: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue << (int)rhsValue);
                            break;
                        }
                        case SHR: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue >> (int)rhsValue);
                            break;
                        }
                        case SHRU: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue >>> (int)rhsValue);
                            break;
                        }
                        case LT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue < rhsValue);
                            break;
                        }
                        case LTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue <= rhsValue);
                            break;
                        }
                        case GT: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue > rhsValue);
                            break;
                        }
                        case GTE: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue >= rhsValue);
                            break;
                        }
                        case EQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue == rhsValue);
                            break;
                        }
                        case NEQ: {
                            JBooleanLiteral jBooleanLiteral = new JBooleanLiteral(si, lhsValue != rhsValue);
                            break;
                        }
                        case BIT_AND: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue & rhsValue);
                            break;
                        }
                        case BIT_OR: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue | rhsValue);
                            break;
                        }
                        case BIT_XOR: {
                            JLongLiteral jLongLiteral = new JLongLiteral(si, lhsValue ^ rhsValue);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unsupported operator");
                        }
                    }
                }
            }
            if (var6_98 != null) {
                assert (this.currentMethod != null);
                TransformationRequest tr = new TransformationRequest(this.currentMethod);
                tr.append(new Replace(binaryExpr, (JNode)var6_98));
                tr.commit();
            }
        }

        @Nonnull
        private JValueLiteral refineCst(@Nonnull SourceInfo si, @Nonnull Number numberValue, @Nonnull JPrimitiveType.JPrimitiveTypeEnum destType) {
            switch (destType) {
                case BOOLEAN: {
                    assert (numberValue.byteValue() == 1 || numberValue.byteValue() == 0);
                    return new JBooleanLiteral(si, numberValue.byteValue() == 1);
                }
                case BYTE: {
                    return new JByteLiteral(si, numberValue.byteValue());
                }
                case SHORT: {
                    return new JShortLiteral(si, numberValue.shortValue());
                }
                case CHAR: {
                    return new JCharLiteral(si, numberValue.charValue());
                }
                case INT: {
                    return new JIntLiteral(si, numberValue.intValue());
                }
                case FLOAT: {
                    return new JFloatLiteral(si, numberValue.floatValue());
                }
                case DOUBLE: {
                    return new JDoubleLiteral(si, numberValue.doubleValue());
                }
                case LONG: {
                    return new JLongLiteral(si, numberValue.longValue());
                }
            }
            throw new AssertionError((Object)"Type not supported to refine a constant");
        }
    }

    @Description(value="Expressions are simplified.")
    public static final class ExpressionsSimplified
    implements Tag {
    }
}

