/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.lookup;

import com.android.jack.Jack;
import com.android.jack.google.common.base.Splitter;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.CommonTypesCache;
import com.android.jack.util.NamingTools;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class JLookup {
    @Nonnull
    protected static final Splitter packageBinaryNameSplitter = Splitter.on('/');
    @Nonnull
    private final CommonTypesCache commonTypesCache = new CommonTypesCache(this);
    @Nonnull
    protected final JPackage topLevelPackage;
    @Nonnull
    private final Map<String, JPackage> packages = new HashMap<String, JPackage>();
    public static final char PACKAGE_SEPARATOR = '/';

    protected JLookup(@Nonnull JPackage topLevelPackage) {
        this.topLevelPackage = topLevelPackage;
    }

    @Nonnull
    public JPackage getPackage(@Nonnull String packageName) throws JPackageLookupException {
        assert (packageName.indexOf(46) == -1);
        JPackage currentPackage = this.topLevelPackage;
        if (!packageName.isEmpty()) {
            for (String name : packageBinaryNameSplitter.split(packageName)) {
                currentPackage = currentPackage.getSubPackage(name);
            }
        }
        assert (Jack.getLookupFormatter().getName(currentPackage).equals(packageName));
        return currentPackage;
    }

    @Nonnull
    public JPackage getOrCreatePackage(@Nonnull String packageName) {
        assert (packageName.indexOf(46) == -1);
        JPackage currentPackage = this.topLevelPackage;
        if (!packageName.isEmpty()) {
            for (String name : packageBinaryNameSplitter.split(packageName)) {
                currentPackage = currentPackage.getOrCreateSubPackage(name);
            }
        }
        assert (Jack.getLookupFormatter().getName(currentPackage).equals(packageName));
        return currentPackage;
    }

    @Nonnull
    public abstract JType getType(@Nonnull String var1) throws JTypeLookupException;

    @Nonnull
    public abstract JClass getClass(@Nonnull String var1) throws JTypeLookupException;

    @Nonnull
    public abstract JEnum getEnum(@Nonnull String var1) throws JTypeLookupException;

    @Nonnull
    public abstract JInterface getInterface(@Nonnull String var1) throws JTypeLookupException;

    @Nonnull
    public abstract JAnnotationType getAnnotationType(@Nonnull String var1) throws JTypeLookupException;

    public abstract void removeType(@Nonnull JType var1);

    @Nonnull
    public JClass getClass(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        return this.commonTypesCache.getClass(type);
    }

    @Nonnull
    public JInterface getInterface(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        return this.commonTypesCache.getInterface(type);
    }

    @Nonnull
    public JType getType(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        return this.commonTypesCache.getType(type);
    }

    @Nonnull
    public JArrayType getArrayType(@Nonnull JType leafType, @Nonnegative int dimension) {
        assert (dimension > 0);
        JType array = leafType;
        for (int i = 0; i < dimension; ++i) {
            array = array.getArray();
        }
        return (JArrayType)array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected <T extends JType> T getType(@Nonnull String signature, @Nonnull Adapter<T> adapter) throws MissingJTypeLookupException {
        JType type;
        Map<String, T> cache;
        Map<String, T> map = cache = adapter.getCache();
        synchronized (map) {
            type = (JType)cache.get(signature);
            if (type == null) {
                int typeNameLength = signature.length();
                assert (typeNameLength > 1) : "Invalid signature '" + signature + "'";
                type = signature.charAt(0) == '[' ? this.findArrayType(signature) : this.findClassOrInterface(signature, adapter);
                cache.put(signature, type);
            }
        }
        return (T)type;
    }

    @Nonnull
    protected JArrayType findArrayType(@Nonnull String typeSignature) throws JTypeLookupException {
        int typeNameLength = typeSignature.length();
        assert (typeNameLength > 0 && typeSignature.charAt(0) == '[');
        int dim = 0;
        do {
            assert (++dim < typeNameLength);
        } while (typeSignature.charAt(dim) == '[');
        return this.getArrayType(this.getType(typeSignature.substring(dim)), dim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends JReferenceType> T getNonArrayType(@Nonnull String signature, @Nonnull Adapter<T> adapter) throws MissingJTypeLookupException {
        JReferenceType type;
        Map<String, T> cache;
        Map<String, T> map = cache = adapter.getCache();
        synchronized (map) {
            type = (JReferenceType)cache.get(signature);
            if (type == null) {
                type = (JReferenceType)this.findClassOrInterface(signature, adapter);
                cache.put(signature, type);
            }
        }
        return (T)type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected JPackage getPackage(@Nonnull String packageName, @Nonnull Adapter<? extends JType> adapter) throws JPackageLookupException {
        Map<String, JPackage> map = this.packages;
        synchronized (map) {
            JPackage found = this.packages.get(packageName);
            if (found == null) {
                String simplePackageName;
                JPackage parent;
                assert (NamingTools.isPackageBinaryName(packageName));
                int separatorIndex = packageName.lastIndexOf(47);
                if (separatorIndex == -1) {
                    parent = this.topLevelPackage;
                    simplePackageName = packageName;
                } else {
                    parent = this.getPackage(packageName.substring(0, separatorIndex), adapter);
                    simplePackageName = packageName.substring(separatorIndex + 1);
                }
                found = adapter.getPackage(parent, simplePackageName);
                this.packages.put(packageName, found);
            }
            return found;
        }
    }

    @Nonnull
    private <T extends JType> T findClassOrInterface(@Nonnull String signature, @Nonnull Adapter<T> adapter) throws MissingJTypeLookupException {
        String simpleName;
        JPackage currentPackage;
        assert (NamingTools.isClassDescriptor(signature)) : "Invalid signature '" + signature + "'";
        int typeNameLength = signature.length();
        int separatorIndex = signature.lastIndexOf(47);
        if (separatorIndex == -1) {
            currentPackage = this.topLevelPackage;
            simpleName = signature.substring(1, typeNameLength - 1);
        } else {
            try {
                currentPackage = this.getPackage(signature.substring(1, separatorIndex), adapter);
                simpleName = signature.substring(separatorIndex + 1, typeNameLength - 1);
            }
            catch (JPackageLookupException p) {
                throw new MissingJTypeLookupException(signature);
            }
        }
        return adapter.getType(currentPackage, simpleName);
    }

    protected static interface Adapter<T extends JType> {
        @Nonnull
        public Map<String, T> getCache();

        @Nonnull
        public T getType(@Nonnull JPackage var1, @Nonnull String var2) throws MissingJTypeLookupException;

        @Nonnull
        public JPackage getPackage(@Nonnull JPackage var1, @Nonnull String var2) throws JPackageLookupException;
    }
}

