/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.library.InputJackLibraryCodec;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.InvalidLibrary;
import com.android.jack.library.JarLibraryCodec;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryVersionException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.OrCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InputLibraryCodec
extends OrCodec<InputLibrary> {
    @CheckForNull
    private String infoString;

    public InputLibraryCodec() {
        super(new InputJackLibraryCodec(), new JarLibraryCodec());
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a Jack library or a Jar";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jack-or-jar";
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputLibrary data) {
        return data.getPath();
    }

    @Nonnull
    public InputLibraryCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }

    @Override
    @CheckForNull
    public InputLibrary checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        StringCodec jackLibCodec = (StringCodec)this.codecList.get(0);
        ((InputJackLibraryCodec)jackLibCodec).setInfoString(this.infoString);
        StringCodec jarCodec = (StringCodec)this.codecList.get(1);
        ArrayList<Throwable> causes = new ArrayList<Throwable>(this.codecList.size());
        try {
            return (InputLibrary)jackLibCodec.checkString(context, string);
        }
        catch (ParsingException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LibraryVersionException || cause instanceof LibraryFormatException) {
                throw e;
            }
            causes.add(cause);
            try {
                return (InputLibrary)jarCodec.checkString(context, string);
            }
            catch (ParsingException e2) {
                causes.add(e2.getCause());
                return new InvalidLibrary(new File(string), causes);
            }
        }
    }
}

