/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.kohsuke.args4j;

import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.IllegalAnnotationError;
import com.android.jack.kohsuke.args4j.Messages;
import com.android.jack.kohsuke.args4j.OptionDef;
import com.android.jack.kohsuke.args4j.Utilities;
import com.android.jack.kohsuke.args4j.spi.BooleanOptionHandler;
import com.android.jack.kohsuke.args4j.spi.ByteOptionHandler;
import com.android.jack.kohsuke.args4j.spi.CharOptionHandler;
import com.android.jack.kohsuke.args4j.spi.DoubleOptionHandler;
import com.android.jack.kohsuke.args4j.spi.EnumOptionHandler;
import com.android.jack.kohsuke.args4j.spi.FileOptionHandler;
import com.android.jack.kohsuke.args4j.spi.FloatOptionHandler;
import com.android.jack.kohsuke.args4j.spi.InetAddressOptionHandler;
import com.android.jack.kohsuke.args4j.spi.IntOptionHandler;
import com.android.jack.kohsuke.args4j.spi.LongOptionHandler;
import com.android.jack.kohsuke.args4j.spi.MapOptionHandler;
import com.android.jack.kohsuke.args4j.spi.OptionHandler;
import com.android.jack.kohsuke.args4j.spi.PatternOptionHandler;
import com.android.jack.kohsuke.args4j.spi.Setter;
import com.android.jack.kohsuke.args4j.spi.ShortOptionHandler;
import com.android.jack.kohsuke.args4j.spi.StringOptionHandler;
import com.android.jack.kohsuke.args4j.spi.URIOptionHandler;
import com.android.jack.kohsuke.args4j.spi.URLOptionHandler;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class OptionHandlerRegistry {
    private static OptionHandlerRegistry instance;
    private final Map<Class, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    public static synchronized OptionHandlerRegistry getRegistry() {
        if (instance == null) {
            instance = new OptionHandlerRegistry();
        }
        return instance;
    }

    private OptionHandlerRegistry() {
        this.initHandlers();
    }

    private void initHandlers() {
        this.registerHandler(Boolean.class, BooleanOptionHandler.class);
        this.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        this.registerHandler(File.class, FileOptionHandler.class);
        this.registerHandler(URL.class, URLOptionHandler.class);
        this.registerHandler(URI.class, URIOptionHandler.class);
        this.registerHandler(Integer.class, IntOptionHandler.class);
        this.registerHandler(Integer.TYPE, IntOptionHandler.class);
        this.registerHandler(Double.class, DoubleOptionHandler.class);
        this.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        this.registerHandler(String.class, StringOptionHandler.class);
        this.registerHandler(Byte.class, ByteOptionHandler.class);
        this.registerHandler(Byte.TYPE, ByteOptionHandler.class);
        this.registerHandler(Character.class, CharOptionHandler.class);
        this.registerHandler(Character.TYPE, CharOptionHandler.class);
        this.registerHandler(Float.class, FloatOptionHandler.class);
        this.registerHandler(Float.TYPE, FloatOptionHandler.class);
        this.registerHandler(Long.class, LongOptionHandler.class);
        this.registerHandler(Long.TYPE, LongOptionHandler.class);
        this.registerHandler(Short.class, ShortOptionHandler.class);
        this.registerHandler(Short.TYPE, ShortOptionHandler.class);
        this.registerHandler(InetAddress.class, InetAddressOptionHandler.class);
        this.registerHandler(Pattern.class, PatternOptionHandler.class);
        this.registerHandler(Map.class, MapOptionHandler.class);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            return handlerClass.getConstructor(CmdLineParser.class, OptionDef.class, Setter.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(Messages.NO_CONSTRUCTOR_ON_HANDLER.format(handlerClass));
        }
    }

    public void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        Utilities.checkNonNull(valueType, "valueType");
        Utilities.checkNonNull(handlerClass, "handlerClass");
        if (!OptionHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException(Messages.NO_OPTIONHANDLER.format(new Object[0]));
        }
        Constructor<? extends OptionHandler> c = OptionHandlerRegistry.getConstructor(handlerClass);
        this.handlerClasses.put(valueType, c);
    }

    protected OptionHandler createOptionHandler(CmdLineParser parser, OptionDef o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        Utilities.checkNonNull(o, "CmdLineParser");
        Utilities.checkNonNull(o, "OptionDef");
        Utilities.checkNonNull(setter, "Sette");
        Class<? extends OptionHandler> h = o.handler();
        if (h == OptionHandler.class) {
            Class t = setter.getType();
            if (Enum.class.isAssignableFrom(t)) {
                return new EnumOptionHandler(parser, o, setter, t);
            }
            handlerType = this.handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError(Messages.UNKNOWN_HANDLER.format(t));
            }
        } else {
            handlerType = OptionHandlerRegistry.getConstructor(h);
        }
        try {
            return handlerType.newInstance(parser, o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }
}

