/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAssertStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.ASSERT_STATEMENT;
    @CheckForNull
    public NExpression testExpression;
    @CheckForNull
    public NExpression arg;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAssertStatement jAssertStatement = (JAssertStatement)node;
        this.testExpression = (NExpression)loader.load(jAssertStatement.getTestExpr());
        this.arg = (NExpression)loader.load(jAssertStatement.getArg());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jAssertStatement.getJCatchBlocks());
        this.sourceInfo = jAssertStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JAssertStatement exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.testExpression != null);
        assert (this.sourceInfo != null);
        JExpression jArg = null;
        if (this.arg != null) {
            jArg = this.arg.exportAsJast(exportSession);
        }
        JAssertStatement jAssertStatement = new JAssertStatement(this.sourceInfo, this.testExpression.exportAsJast(exportSession), jArg);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jAssertStatement));
        }
        return jAssertStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.testExpression);
        out.writeNode(this.arg);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.testExpression = in.readNode(NExpression.class);
        this.arg = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

