/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NDoStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.DO_STATEMENT;
    @CheckForNull
    public NExpression testExpression;
    @CheckForNull
    public NStatement body;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDoStatement jDoStatement = (JDoStatement)node;
        this.testExpression = (NExpression)loader.load(jDoStatement.getTestExpr());
        this.body = (NStatement)loader.load(jDoStatement.getBody());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jDoStatement.getJCatchBlocks());
        this.sourceInfo = loader.load(jDoStatement.getSourceInfo());
    }

    @Override
    @Nonnull
    public JDoStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.testExpression != null);
        assert (this.sourceInfo != null);
        JStatement jBody = this.body != null ? this.body.exportAsJast(exportSession) : null;
        JDoStatement jDoStatement = new JDoStatement(this.sourceInfo.exportAsJast(exportSession), this.testExpression.exportAsJast(exportSession), jBody);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jDoStatement));
        }
        return jDoStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.testExpression);
        out.writeNode(this.body);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.testExpression = in.readNode(NExpression.class);
        this.body = in.readNode(NStatement.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

